/*
 * Created on 2003/08/14
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.listoperation.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionNodeControl;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.command.control.CommandMappingTableResource;


/**
 * m[h폜GWɒʒm郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeDeleteModel {
    /* MO */
    private static Logger logger;

    /* m[hIPAhX */
    private String ipaddress;

    public NodeDeleteModel(String ipaddress) {
        logger = Logger.getLogger(this.getClass().getName());
        this.ipaddress = ipaddress;
    }

    /**
     * m[h폜GWɒʒm܂B
     *
     * @param engineAddress GWAddress
     * @param ipaddress 폜m[hIP Address
     */
    public void removeNode(String engineAddress, String ipaddress) {
        // logger.info("Engine address : " + engineAddress);
        // logger.info("Target IP address : " + ipaddress);

        try {
            ConnectionNodeControl threadstop =
                new ConnectionNodeControl(engineAddress);
            threadstop.requestThread(
                ipaddress, CommandMappingTableResource.THREAD_STOP_COMMAND_ID,
                null);
        } catch (EngineConnectException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     * m[ho^e[uYIPAhX폜̌ʂƂăXg̎悵ĕԂ
     *
     * @param engineAddress GWAhX
     * @param sortColumn m[hĎe[u\[gJ
     * @param sortDirection m[hĎe[u\[g
     * @return nodeInfoList m[hĎ񃊃Xg
     * @throws EngineConnectException GWƂ̐ڑňُoꍇ
     * @throws IOException GWƂ̐ڑňُoꍇ
     */
    public ArrayList getList(
        String engineAddress, String sortColumn, String sortDirection)
        throws EngineConnectException, IOException {
        ArrayList nodeInfoList = null;

        ConnectionNodeInformation connectNodeInfoList =
            new ConnectionNodeInformation(engineAddress);

        nodeInfoList =
            connectNodeInfoList.getNodeInformationList(
                sortColumn, sortDirection);

        return nodeInfoList;
    }
}
