/*
 * Created on 2003/08/24
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.start;

import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.preference.Preference;
import netjfwatcher.resourceconfig.EngineResourceConfig;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * ʃm[h}l[W̃j[JSPNANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeManagerMenuAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            engineAddress = "localhost";
            logger.warning("Not Engine Addreess : " + engineAddress);
        }

        String clientXmlSocketPort =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getClientXmlSocketPort();
        String servername = request.getParameter(Preference.SERVER_NAME);

        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(
            Preference.CLIENT_XML_SOCKET_PORT, clientXmlSocketPort);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
