/*
 * Created on 2004/04/17
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemap.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;
import netjfwatcher.engine.socket.ConnectionNodeMapLink;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;


/**
 * m[hMapLink̑GWɒʒm郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapLinkModel {
    /* MO */
    private static Logger logger;

    /**
     *@m[hMapLink̑GWɒʒmNXCX^X
     * ܂B
     */
    public NodeMapLinkModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[hMapLink̍XVGWɒʒm܂B
     *
     * @param engineAddress GWAhX
     * @param node0address m[hX_z
     * @param node1address m[hY_z
     * @return resultNodeMapLink m[hMap Link
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public NodeMapLinkInformation updateMapLink(
        String engineAddress, String[] node0address, String[] node1address)
        throws EngineConnectException, IOException {
        ArrayList node0List = new ArrayList();
        ArrayList node1List = new ArrayList();

        for (int i = 0; i < node0address.length; i++) {
            node0List.add(node0address[i]);
            node1List.add(node1address[i]);
        }

        NodeMapLinkInformation nodeMapLinkInfo = new NodeMapLinkInformation();
        nodeMapLinkInfo.setNode0address(node0List);
        nodeMapLinkInfo.setNode1address(node1List);

        NodeMapLinkInformation resultNodeMapLink = null;

        /**
         * SẴGWɃm[hMap LinkXV
         */
        ArrayList engineList =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getEngineInfoList();
        boolean isEngineConnectSuccess = false;

        for (int i = 0; i < engineList.size(); i++) {
            String testEngineAddress =
                ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();
            logger.info("Check engine connect : " + testEngineAddress);

            ConnectionNodeMapLink connection =
                new ConnectionNodeMapLink(testEngineAddress);

            try {
                resultNodeMapLink =
                    connection.updateNodeMapInformation(nodeMapLinkInfo);
                isEngineConnectSuccess = true;
            } catch (EngineConnectException e) {
                logger.warning("EngineConnectException " + e.getMessage());
            } catch (IOException e) {
                logger.warning("IOException " + e.getMessage());
            }
        }

        if (!isEngineConnectSuccess) {
            throw new EngineConnectException(
                "EngineConnectException, Abort all connect Engine count = "
                + engineList.size());
        }

        return resultNodeMapLink;
    }

    /**
     * GWփm[hMap LinkXVvʒm܂B
     *
     * @param nodeMapLinkInfo m[hMap Link
     * @return resultNodeMapLink m[hMapN
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public NodeMapLinkInformation setMapLink(
        NodeMapLinkInformation nodeMapLinkInfo)
        throws EngineConnectException, IOException {
        NodeMapLinkInformation resultNodeMapLink = null;

        /*
         * SẴGWɃm[hMap LinkXV
         */
        ArrayList engineList =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getEngineInfoList();
        boolean isEngineConnectSuccess = false;

        for (int i = 0; i < engineList.size(); i++) {
            String testEngineAddress =
                ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();
            logger.info("Check engine connect : " + testEngineAddress);

            ConnectionNodeMapLink connection =
                new ConnectionNodeMapLink(testEngineAddress);

            try {
                resultNodeMapLink =
                    connection.setNodeMapInformation(nodeMapLinkInfo);
                isEngineConnectSuccess = true;
            } catch (EngineConnectException e) {
                logger.warning("EngineConnectException " + e.getMessage());
            } catch (IOException e) {
                logger.warning("IOException " + e.getMessage());
            }
        }

        if (!isEngineConnectSuccess) {
            throw new EngineConnectException(
                "EngineConnectException, Abort all connect Engine count = "
                + engineList.size());
        }

        return resultNodeMapLink;
    }

    /**
     * m[hMapLinkGW擾ĕԂ܂B
     *
     * @param engineAddress GWAhX
     * @param sortColumn \[gJ
     * @param sortDirection \[g
     * @return nodeMapLink m[hMapN
     * @throws EngineConnectException GWƂ̐ڑňُ킪΂
     * @throws IOException GWƂ̐ڑňُ킪΂
     */
    public NodeMapLinkInformation getNodeMapLinkInfo(
        String engineAddress, String sortColumn, String sortDirection)
        throws EngineConnectException, IOException {
        NodeMapLinkInformation nodeMapLink = null;

        logger.info("Connect engineAddress : " + engineAddress);

        if (engineAddress.equals("all")) {
            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();
            nodeMapLink = new NodeMapLinkInformation();

            for (int i = 0; i < engineList.size(); i++) {
                String testEngineAddress =
                    ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();
                logger.info("Check engine connect : " + testEngineAddress);

                NodeMapLinkInformation workNodeMapLink = null;

                try {
                    ConnectionNodeMapLink connection =
                        new ConnectionNodeMapLink(testEngineAddress);
                    workNodeMapLink = connection.getNodeMapInformation();

                    if (workNodeMapLink != null) {
                        nodeMapLink.setNode0address(
                            workNodeMapLink.getNode0address());
                        nodeMapLink.setNode1address(
                            workNodeMapLink.getNode1address());
                    }
                } catch (EngineConnectException e) {
                    logger.info("abort engine : " + testEngineAddress);
                    logger.info(e.getMessage());
                } catch (IOException e) {
                    logger.info("abort engine : " + testEngineAddress);
                    logger.info(e.getMessage());
                }
            }
        } else {
            ConnectionNodeMapLink connection =
                new ConnectionNodeMapLink(engineAddress);

            try {
                nodeMapLink = connection.getNodeMapInformation();
            } catch (EngineConnectException e) {
                logger.warning("EngineConnectException " + e.getMessage());
                throw e;
            } catch (IOException e) {
                logger.warning("IOException " + e.getMessage());
                throw e;
            }
        }

        return nodeMapLink;
    }
}
