/*
 * Created on 2004/04/14
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemap.model;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.socket.ConnectionNodeControl;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.noderegister.model.NodeRegistException;
import netjfwatcher.noderegister.model.NodeRegisterModel;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;


/**
 * m[hMapyуm[hNGWƑMNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapModel {
    private static Logger logger = null;

    public NodeMapModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * wm[hm[hMap폜܂B
     *
     * @param engineAddress GWAhX
     * @param nodeAddress m[hIPAhX
     * @return
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public boolean deleteNode(String engineAddress, String nodeAddress)
        throws EngineConnectException, IOException {
        logger.info(
            "Delete Node IP=" + nodeAddress + " Engine IP=" + engineAddress);

        NodeInformation nodeInfo = new NodeInformation();

        if (engineAddress.equals("all")) {
            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();

            for (int i = 0; i < engineList.size(); i++) {
                String testEngineAddress =
                    ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();

                try {
                    ConnectionNodeControl connection =
                        new ConnectionNodeControl(testEngineAddress);
                    connection.requestThread(
                        nodeAddress,
                        CommandMappingTableResource.THREAD_STOP_COMMAND_ID,
                        nodeInfo);
                } catch (EngineConnectException e) {
                    logger.info("abort engine : " + testEngineAddress);
                    logger.info(e.getMessage());
                } catch (IOException e) {
                    logger.info("abort engine : " + testEngineAddress);
                    logger.info(e.getMessage());
                }
            }
        } else {
            try {
                ConnectionNodeControl connection =
                    new ConnectionNodeControl(engineAddress);
                connection.requestThread(
                    nodeAddress,
                    CommandMappingTableResource.THREAD_STOP_COMMAND_ID, nodeInfo);
            } catch (EngineConnectException e) {
                logger.warning("EngineConnectException " + e.getMessage());
                e.printStackTrace();
            } catch (IOException e) {
                logger.warning("IOException " + e.getMessage());
                e.printStackTrace();
            }
        }

        return true;
    }

    private boolean updateNodeMap(NodeInformation nodeInfo)
        throws NodeRegistException, EngineConnectException, IOException {
        String ipaddress = null;
        String engineAddress = nodeInfo.getEngineAddress();
        String nodeAddress = nodeInfo.getIpaddress();
        String nodeName = null;
        String nodeIPAaddress = nodeInfo.getIpaddress();

        try {
            InetAddress host = InetAddress.getByName(nodeIPAaddress);
            ipaddress = host.getHostAddress();
            nodeName = host.getHostName();
        } catch (UnknownHostException e) {
            /* m[hIP Addressُ */
            logger.warning(
                "UnknownHostException : " + " IP Address = " + nodeIPAaddress
                + " " + e.getMessage());
            throw new NodeRegistException(
                "UnknownHostException : " + " IP Address = " + nodeIPAaddress
                + " " + e.getMessage());
        }

        if (
            (nodeInfo.getNodename() == null)
                || nodeInfo.getNodename().equals("")) {
            nodeInfo.setNodename(nodeName);
        }

        int httpPeriod = 0;

        if (!nodeInfo.getHttpPeriod().equals("--")) {
            try {
                httpPeriod = Integer.parseInt(nodeInfo.getHttpPeriod());
            } catch (NumberFormatException e) {
                logger.warning(
                    "NumberFormatException " + e.getMessage()
                    + " Http period = " + nodeInfo.getHttpPeriod());
                throw new NodeRegistException(
                    "NumberFormatException " + e.getMessage()
                    + " Http period = " + nodeInfo.getHttpPeriod());
            }
        }

        if (httpPeriod > 0) {
            try {
                URL accessURL = new URL(nodeInfo.getHttpUrl());

                if (
                    (accessURL.getHost() == null)
                        || accessURL.getHost().equals("")
                        || (accessURL.getProtocol() == null)
                        || accessURL.getProtocol().equals("")) {
                    logger.warning(
                        "Illegal URL " + "   host=" + accessURL.getHost()
                        + "  protocol=" + accessURL.getProtocol());
                    throw new NodeRegistException(
                        "Illegal URL " + "   host=" + accessURL.getHost()
                        + "  protocol=" + accessURL.getProtocol());
                }
            } catch (MalformedURLException e) {
                logger.warning(e.getMessage() + " : " + nodeInfo.getHttpUrl());
                throw new NodeRegistException(
                    e.getMessage() + " : " + nodeInfo.getHttpUrl());
            }
        }

        NodeRegisterModel noderegisterModel = new NodeRegisterModel();

        NodeInformation targetIPNodeInfo =
            noderegisterModel.getIPTarget(engineAddress, nodeAddress);

        if (targetIPNodeInfo == null) {
            ConnectionNodeControl connectionNodeControl =
                new ConnectionNodeControl(engineAddress);
            connectionNodeControl.requestThread(
                nodeAddress, CommandMappingTableResource.THREAD_START_COMMAND_ID,
                nodeInfo);
        } else {
            ConnectionNodeControl connectionNodeControl =
                new ConnectionNodeControl(engineAddress);
            connectionNodeControl.requestThread(
                nodeAddress,
                CommandMappingTableResource.THREAD_RESTART_COMMAND_ID, nodeInfo);
        }

        return true;
    }

    /*
     * m[h̏ꍇɃhCm[hƂ܂B
     *
     * @param nodeInfo m[hĎ
     * @return nodeInfo m[hĎ
     * @throws NodeRegistException m[ho^ُ̏ꍇ
     */
    private NodeInformation checkNodeAddoress(NodeInformation nodeInfo)
        throws NodeRegistException {
        String ipaddress = null;
        String nodeName = null;
        String nodeIPAaddress = nodeInfo.getIpaddress();

        try {
            InetAddress host = InetAddress.getByName(nodeIPAaddress);
            ipaddress = host.getHostAddress();
            nodeName = host.getHostName();
            nodeInfo.setIpaddress(ipaddress);
        } catch (UnknownHostException e) {
            /* m[hIP Addressُ */
            logger.warning(
                "UnknownHostException : " + " IP Address = " + nodeIPAaddress
                + " " + e.getMessage());
            throw new NodeRegistException(
                "UnknownHostException : " + " IP Address = " + nodeIPAaddress
                + " " + e.getMessage());
        }

        if (
            (nodeInfo.getNodename() == null)
                || nodeInfo.getNodename().equals("")) {
            nodeInfo.setNodename(nodeName);
        }

        return nodeInfo;
    }

    /*
     * o^m[hHTTPĎLȏꍇɃ`FbNURL̐`FbN܂B
     * ُȏꍇɂNodeRegistExceptionX[܂B
     *
     * @param nodeInfo m[hĎ
     * @throws NodeRegistException m[ho^ُ̏ꍇ
     */
    private void checkNodeHttp(NodeInformation nodeInfo)
        throws NodeRegistException {
        int httpPeriod = 0;

        if (!nodeInfo.getHttpPeriod().equals("--")) {
            try {
                httpPeriod = Integer.parseInt(nodeInfo.getHttpPeriod());
            } catch (NumberFormatException e) {
                logger.warning(
                    "NumberFormatException " + e.getMessage()
                    + " Http period = " + nodeInfo.getHttpPeriod());
                throw new NodeRegistException(
                    "NumberFormatException " + e.getMessage()
                    + " Http period = " + nodeInfo.getHttpPeriod());
            }
        }

        if (httpPeriod > 0) {
            try {
                URL accessURL = new URL(nodeInfo.getHttpUrl());

                if (
                    (accessURL.getHost() == null)
                        || accessURL.getHost().equals("")
                        || (accessURL.getProtocol() == null)
                        || accessURL.getProtocol().equals("")) {
                    logger.warning(
                        "Illegal URL " + "   host=" + accessURL.getHost()
                        + "  protocol=" + accessURL.getProtocol());
                    throw new NodeRegistException(
                        "Illegal URL " + "   host=" + accessURL.getHost()
                        + "  protocol=" + accessURL.getProtocol());
                }
            } catch (MalformedURLException e) {
                logger.warning(e.getMessage() + " : " + nodeInfo.getHttpUrl());
                throw new NodeRegistException(
                    e.getMessage() + " : " + nodeInfo.getHttpUrl());
            }
        }
    }

    public boolean updateNodeMap(ArrayList nodeInfoList)
        throws EngineConnectException, IOException {
        ArrayList engineList =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getEngineInfoList();
        String connectEngineAddress = "";
        NodeRegisterModel noderegisterModel = new NodeRegisterModel();

        for (int j = 0; j < engineList.size(); j++) {
            connectEngineAddress =
                ((EngineResourceInfo) engineList.get(j)).getEngineIPaddress();

            ArrayList registerNodeList = null;

            try {
                registerNodeList =
                    noderegisterModel.getList(connectEngineAddress);
            } catch (EngineConnectException e) {
                logger.warning(
                    "EngineConnectException " + e.getMessage()
                    + " Engine Address = " + connectEngineAddress);

                continue;
            } catch (IOException e) {
                logger.warning(
                    "IOException " + e.getMessage() + " Engine Address = "
                    + connectEngineAddress);

                continue;
            }

            /* VKo^m[hXg */
            ArrayList addNodeList = new ArrayList();

            /* o^ς݃m[hXg */
            ArrayList updateNodeList = new ArrayList();

            for (int i = 0; i < nodeInfoList.size(); i++) {
                NodeInformation saveNodeInfo =
                    (NodeInformation) nodeInfoList.get(i);
                String nodeInfoEngineAddress = saveNodeInfo.getEngineAddress();

                if (
                    checkEngineAddress(
                            connectEngineAddress, nodeInfoEngineAddress)) {
                    /*
                     * GWAddressvm[ĥ݃`FbN
                     */
                    String saveNodeAddress = saveNodeInfo.getIpaddress();

                    /*
                     * ɓo^ς݃m[h`FbN
                     */
                    boolean isRegisterNode = false;

                    for (
                        int checkRegNodeCount = 0;
                            checkRegNodeCount < registerNodeList.size();
                            checkRegNodeCount++) {
                        NodeInformation registerNodeInfo =
                            (NodeInformation) registerNodeList.get(
                                checkRegNodeCount);

                        if (
                            saveNodeAddress.equals(
                                    registerNodeInfo.getIpaddress())) {
                            isRegisterNode = true;
                        }
                    }

                    if (isRegisterNode) {
                        /*
                             * ɓo^ς݃m[ĥ߂ɁAm[hXVXg
                             * m[hĎǉ
                             */
                        try {
                            checkNodeHttp(saveNodeInfo);
                            updateNodeList.add(saveNodeInfo);
                        } catch (NodeRegistException e1) {
                            logger.warning(
                                "NodeRegistException " + e1.getMessage()
                                + " Node IP = " + saveNodeInfo.getIpaddress());
                        }
                    } else {
                        /* m[hǉXgɃm[hĎǉ */
                        try {
                            checkNodeHttp(saveNodeInfo);
                            addNodeList.add(checkNodeAddoress(saveNodeInfo));
                        } catch (NodeRegistException e1) {
                            logger.warning(
                                "NodeRegistException " + e1.getMessage()
                                + " Node IP = " + saveNodeInfo.getIpaddress());
                        }
                    }
                }
            }

            ConnectionNodeControl connectionNodeControl =
                new ConnectionNodeControl(connectEngineAddress);

            if (updateNodeList.size() > 0) {
                connectionNodeControl.requestThread(
                    CommandMappingTableResource.THREAD_RESTART_COMMAND_ID,
                    updateNodeList);
            }

            if (addNodeList.size() > 0) {
                connectionNodeControl.requestThread(
                    CommandMappingTableResource.THREAD_START_COMMAND_ID,
                    addNodeList);
            }
        }

        return true;
    }

    /*
     * GWڑAhXƃm[h̃GWAhXv邩`FbN܂B
     * GWڑAhX127.0.0.1localhost̏ꍇAm[h̃GWAhX
     * zXgAhXŁAlocalhostłɂ炸svƂȂꍇ̂ŁA
     * lă`FbN܂B
     *
     * @param connectEngineAddress GWڑAhX
     * @param nodeInfoEngineAddress m[h̃GWAhX
     * @return@GWڑAhXƃm[h̃GWAhXv邩
     * true:vAfalse:sv
     */
    private boolean checkEngineAddress(
        String connectEngineAddress, String nodeInfoEngineAddress) {
        if (connectEngineAddress.equals(nodeInfoEngineAddress)) {
            return true;
        } else {
            if (
                connectEngineAddress.equals("127.0.0.1")
                    || connectEngineAddress.equals("localhost")) {
                String checkLocalEngineAddress;

                try {
                    checkLocalEngineAddress =
                        InetAddress.getLocalHost().getHostAddress();
                } catch (UnknownHostException e) {
                    e.printStackTrace();

                    return false;
                }

                if (checkLocalEngineAddress.equals(nodeInfoEngineAddress)) {
                    return true;
                }
            }
        }

        return false;
    }

    /**
     * m[hMap`p̃m[hĎGW擾ĕԂ܂B
     *
     * @param engineAddress GWAhX
     * @param sortColumn m[hĎe[u\[gΏۃJ
     * @param sortDirection m[hĎe[u\[g
     * @return nodeInfoList m[hĎ񃊃Xg
     */
    public ArrayList getNodeInfoList(
        String engineAddress, String sortColumn, String sortDirection) {
        ConnectionNodeInformation nodeInfoConnection = null;
        ArrayList nodeInfoList = null;

        if (engineAddress.equals("all")) {
            /* wGWAhX'all'̏ꍇ́A\[XɋLqĂSẴGWAhX擾 */
            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();
            nodeInfoList = new ArrayList();

            for (int i = 0; i < engineList.size(); i++) {
                String testEngineAddress =
                    ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();

                ArrayList workNodeInfoList = null;

                try {
                    nodeInfoConnection =
                        new ConnectionNodeInformation(testEngineAddress);
                    workNodeInfoList =
                        nodeInfoConnection.getNodeInformationList(
                            sortColumn, sortDirection);

                    if (
                        (workNodeInfoList != null)
                            && (workNodeInfoList.size() > 0)) {
                        for (int j = 0; j < workNodeInfoList.size(); j++) {
                            NodeInformation nodeInfo =
                                (NodeInformation) workNodeInfoList.get(j);
                            nodeInfoList.add(nodeInfo);
                        }
                    }
                } catch (EngineConnectException e) {
                    logger.info("abort engine : " + testEngineAddress);
                    logger.info(e.getMessage());
                } catch (IOException e) {
                    logger.info("abort engine : " + testEngineAddress);
                    logger.info(e.getMessage());
                }
            }
        } else {
            /* w̃GWAhXʂ̏ꍇ́AwGWAhX擾 */
            try {
                nodeInfoConnection =
                    new ConnectionNodeInformation(engineAddress);
                nodeInfoList =
                    nodeInfoConnection.getNodeInformationList(
                        sortColumn, sortDirection);
            } catch (EngineConnectException e) {
                logger.warning("EngineConnectException " + e.getMessage());
                e.printStackTrace();
            } catch (IOException e) {
                logger.warning("IOException " + e.getMessage());
                e.printStackTrace();
            }
        }

        return nodeInfoList;
    }
}
