/*
 * Created on 2003/08/12
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.nodeview;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.noderegister.model.NodeRegisterModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * m[hr[t[ZbgANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeViewFrame extends Action {
    private static Logger logger;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not engine address : " + engineAddress);
        }

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.SERVER_NAME, servername);

        String ipaddress = request.getParameter(Preference.IPADDRESS);
        request.setAttribute(Preference.NODE_IPADDRESS, ipaddress);

        String convIPAddress = ipaddress.replace('.', '_');

        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);

        /* SNMPĎm[h */
        NodeRegisterModel noderegister = new NodeRegisterModel();
        NodeInformation nodeInfo =
            noderegister.getIPTarget(engineAddress, ipaddress);

        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        if (
            (nodeInfo != null)
                && !nodeInfo.getSnmpLevel().equals(Preference.SNMP_LEVEL0)) {
            /* SNMPĎm[h̏ꍇ̃tH[h */
            return mapping.findForward(Preference.SUCCESS_SNMP);
        }

        /* SNMPĎm[hłȂꍇ̃tH[h */
        return mapping.findForward(Preference.SUCCESS);
    }
}
