/*
 * Created on 2003/07/31
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.nodeview.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionInterfaceMib;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.InterfaceMib;


/**
 * m[h̃C^tF[XMIB擾NXłB
 * C^tF[XMIB͈ȉ̒ʂłB
 *@EIfIndex
 * EIfDesc
 * EIfType
 * EIfMtu
 * EIfSpeed
 * EIfPhysAddress
 * EIfStatus
 * EIfAdminStatus
 * EIfOperStatus
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeInterfaceViewModel {
    /* MO */
    private static Logger logger;

    /* m[hIPAhX */
    private String ipaddress;

    /**
     *@m[h̃C^tF[X擾NXCX^X𐶐܂B
     *
     * @param ipaddress m[hIPAhX
     */
    public NodeInterfaceViewModel(String ipaddress) {
        logger = Logger.getLogger(this.getClass().getName());
        this.ipaddress = ipaddress;
    }

    /**
     * GWInterface MIB擾܂B
     *
     * @param engineAddress GWAhX
     * @return interfaceList Interface MIBXg
     */
    public ArrayList getInterfaceMibList(String engineAddress) {
        ArrayList interfaceList = null;

        try {
            ConnectionInterfaceMib connection =
                new ConnectionInterfaceMib(engineAddress);

            interfaceList = connection.getInterfaceMib(ipaddress);
        } catch (EngineConnectException e) {
            logger.warning("EngineConnectException " + e.getMessage());
        } catch (IOException e) {
            logger.warning("IOException " + e.getMessage());
        }

        if ((interfaceList == null) || (interfaceList.size() == 0)) {
            // logger.warning("List size abort");
            interfaceList = new ArrayList();

            InterfaceMib interfaceMib = new InterfaceMib();
            interfaceMib.setIfIndex("--");
            interfaceMib.setIfDesc("--");
            interfaceMib.setIfType("--");
            interfaceMib.setIfMtu("--");
            interfaceMib.setIfSpeed("--");
            interfaceMib.setIfPhysAddress("--");
            interfaceMib.setIfStatus(" ");
            interfaceMib.setIfAdminStatus("--");
            interfaceMib.setIfOperStatus("--");
            interfaceList.add(interfaceMib);
        }

        return interfaceList;
    }
}
