/*
 * Created on 2004/04/08
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodeview.snmpsystem;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.SystemMib;
import netjfwatcher.nodeview.snmpsystem.model.NodeSNMPSystemModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * m[h̃VXeMIB\ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeViewSNMPSystemAction extends Action {
    /* MO */
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Addreess : " + engineAddress);
        }

        String ipAddress = request.getParameter(Preference.IPADDRESS);
        NodeSNMPSystemModel snmpSystem = new NodeSNMPSystemModel();

        SystemMib systemMibInfo =
            snmpSystem.getSystemMib(engineAddress, ipAddress);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);
        request.setAttribute(Preference.NODE_IPADDRESS, ipAddress);

        String convIPAddress = ipAddress.replace('.', '_');

        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(Preference.SNMP_SYSTEM_MIB, systemMibInfo);

        return mapping.findForward(Preference.SUCCESS);
    }
}
