/*
 * Created on 2004/06/28
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.statisticsmib.action;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.noderegister.model.NodeRegisterModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * NCAg̎wIPAhXɑΉSNMP MIBv̎ݒ
 * NCAgɕԂANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class StatisticsMibPropertyAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not engine address");
        }

        /* wm[hIPAhXSNMP Community擾 */
        String ipAddress = request.getParameter(Preference.IPADDRESS);
        NodeRegisterModel nodeModel = new NodeRegisterModel();

        NodeInformation nodeInfo =
            nodeModel.getIPTarget(engineAddress, ipAddress);

        String community = "";

        if (nodeInfo != null) {
            community = nodeInfo.getRoCommunity();
        }

        netjfwatcher.statisticsmib.model.StatisticsMibInfo statisticsMibInfo =
            new netjfwatcher.statisticsmib.model.StatisticsMibInfo();
        statisticsMibInfo.setIpaddress(ipAddress);
        statisticsMibInfo.setCommunity(community);
        statisticsMibInfo.setThresholdtype(
            Preference.SNMP_STATISTICS_THRESHOLD_TYPE_NONE);

        request.setAttribute(
            Preference.SNMP_STATISTICS_MIB_INFO, statisticsMibInfo);

        // NCAguEŨt[ɕtT[oyIPAhXZbg
        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String frameNameforServername = servernamework2.replace('-', '_');
        String convIPAddress = ipAddress.replace('.', '_');
        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(
            Preference.FRAME_NAME_AT_SERVER_NAME, frameNameforServername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
