/*
 * Created on 2004/08/10
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.upload.model;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;
import netjfwatcher.nodemap.model.NodeMapLinkModel;
import netjfwatcher.noderegister.NodeAddViewAction;
import netjfwatcher.noderegister.model.NodeRegistException;
import netjfwatcher.noderegister.model.NodeRegisterModel;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;


/**
 * m[hꊇo^s\bh܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeBundleRegister {
    /* MO */
    private static Logger logger = null;

    public NodeBundleRegister() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[hꊇo^󋵂NCAgɒʒm܂B
     * ܂AIɃNCAgƂ̐ڑԂmF܂B
     *
     * @param socket Socket
     * @throws InterruptedException WaitԂňُ킪ꍇ
     * @throws SocketException NCAgؒfꂽꍇ
     * @throws IOException NCAgƂ̒ʐMɈُ킪ꍇ
     */
    public void communicateClient(Socket socket)
        throws InterruptedException, SocketException, IOException {
        try {
            OutputStreamWriter osw =
                new OutputStreamWriter(socket.getOutputStream(), "UTF-8");

            NodeRegisterStatusInfo data = null;

            /* NCAgؒf܂Ń[v */
            while (true) {
                Thread.sleep(1000);

                /* o^󋵃L[݂Ă胋[v */
                while (true) {
                    // m[ho^󋵃L[󋵂o
                    data = NodeRegisterQueue.getInstance().pop();

                    // o^󋵏񂪑݂ꍇ̓NCAg֒ʒm
                    if ((data != null)) {
                        // m[ho^
                        String result =
                            data.getNodeName() + " : " + data.getIpAddress()
                            + " : " + data.getNodeRegisterResult();

                        /*
                         * NCAgւ̉MXMLf[^쐬EM
                         */
                        String str =
                            "<info>" + "<resp_info resp_str=" + "\'" + result
                            + "\'" + "/>" + "<resp_info registerTotal=" + "\'"
                            + NodeRegisterQueue.getInstance()
                                               .getNodeRegisterTotal() + "\'"
                            + "/>" + "<resp_info registerOK=" + "\'"
                            + NodeRegisterQueue.getInstance().getNodeRegisterOK()
                            + "\'" + "/>" + "<resp_info registerAbort=" + "\'"
                            + NodeRegisterQueue.getInstance()
                                               .getNodeRegisterAbort() + "\'"
                            + "/>" + "</info>" + "\0";
                        osw.write(str);
                        osw.flush();
                    } else {
                        // o^󋵏Ȃ̏ꍇ̓[vbreak
                        break;
                    }
                }

                /* NCAgƂ̐ڑԊmF */
                String str =
                    "<resp_info resp_str=" + "\'" + "Connection_Check" + "\'"
                    + "/>" + "\0";
                osw.write(str);
                osw.flush();
            }
        } catch (SocketException ex) {
            // NCAgƂ̐ڑf
            logger.warning(ex.getMessage());
            throw ex;
        } catch (IOException ex) {
            logger.warning(ex.getMessage());
            ex.printStackTrace();
            throw ex;
        }
    }

    /**
     *
     * @param nodeInfoList
     * @param linkList
     */
    public synchronized void registerNode(
        ArrayList nodeInfoList, ArrayList linkList) {
        /*  */
        NodeRegisterQueue.getInstance().resetQueue();
        NodeRegisterQueue.getInstance().setTotalNode(nodeInfoList.size());

        for (int i = 0; i < nodeInfoList.size(); i++) {
            NodeRegisterStatusInfo info = new NodeRegisterStatusInfo();

            try {
                info.setNodeName(((String[]) nodeInfoList.get(i))[0]);
                info.setIpAddress(((String[]) nodeInfoList.get(i))[1]);
                info.setNodeRegisterResult("Register OK");

                /* GWɃm[ho^ʒm */
                NodeInformation registerNodeInfo =
                    this.createNodeInfo((String[]) nodeInfoList.get(i));

                NodeRegisterModel nodeRegisterModel = new NodeRegisterModel();
                nodeRegisterModel.registerUploadNode(registerNodeInfo);

                NodeRegisterQueue.getInstance().countNodeRegisterOK();
            } catch (NodeRegistException e) {
                info.setNodeRegisterResult(e.getMessage());
                NodeRegisterQueue.getInstance().countNodeRegisterAbort();
            } catch (EngineConnectException e) {
                info.setNodeRegisterResult(e.getMessage());
                NodeRegisterQueue.getInstance().countNodeRegisterAbort();
            } catch (IOException e) {
                info.setNodeRegisterResult(e.getMessage());
                NodeRegisterQueue.getInstance().countNodeRegisterAbort();
            } finally {
                NodeRegisterQueue.getInstance().push(info);
            }
        }

        /* Linkf[^x[XɊi[ */
        ArrayList node0addressList = new ArrayList();
        ArrayList node1addressList = new ArrayList();

        for (int i = 0; i < linkList.size(); i++) {
            String[] address = (String[]) linkList.get(i);
            node0addressList.add(address[0]);
            node1addressList.add(address[1]);
        }

        try {
            this.registerLink(node0addressList, node1addressList);
        } catch (EngineConnectException e) {
            logger.warning(e.getMessage());
        } catch (IOException e) {
            logger.warning(e.getMessage());
        }
    }

    /**
     * w肳ꂽNf[^x[XɊi[܂B
     *
     * @param linkInfo Ni[zilinkInfo[0]Fn_AlinkInfo[1]FI_j
     * @throws EngineConnectException
     * @throws IOException
     */
    private void registerLink(
        ArrayList node0addressList, ArrayList node1addressList)
        throws EngineConnectException, IOException {
        NodeMapLinkInformation nodeMapLinkInfo = new NodeMapLinkInformation();
        nodeMapLinkInfo.setNode0address(node0addressList);
        nodeMapLinkInfo.setNode1address(node1addressList);

        NodeMapLinkModel mapLinkModel = new NodeMapLinkModel();
        mapLinkModel.setMapLink(nodeMapLinkInfo);
    }

    /**
     * m[hĎi[z񂩂m[hĎCX^X𐶐āA
     * GWɃm[ho^ʒms܂B
     *
     * @param nodeInfoArray m[hĎz
     * @return registerNodeInfo m[hĎCX^X
     * @throws NodeRegistException
     * @throws EngineConnectException
     * @throws IOException
     */
    public NodeInformation createNodeInfo(String[] nodeInfoArray)
        throws NodeRegistException, EngineConnectException, IOException {
        /* m[hĎp[^ɏlZbg */
        String nodename = "";
        String ipaddress = "";
        String group = "";
        String engineAddress = "";
        String nodeX = "";
        String nodeY = "";
        String nodekind = "";
        String pingPeriod = NodeAddViewAction.INITIAL_NODE_PING_PERIOD;
        String pingThreshhold = NodeAddViewAction.INITIAL_NODE_PING_THRESHOLD;
        String snmpVersion = NodeAddViewAction.INITIAL_NODE_SNMP_VERSION;
        String snmpPeriod = NodeAddViewAction.INITIAL_NODE_SNMP_PERIOD;
        String snmpLevel = "";
        String roCommunity = NodeAddViewAction.INITIAL_NODE_SNMP_ROCOMMUNITY;
        String rwCommunity = NodeAddViewAction.INITIAL_NODE_SNMP_RWCOMMUNITY;
        String httpUrl = NodeAddViewAction.INITIAL_NODE_HTTP_URL;
        String httpPeriod = NodeAddViewAction.INITIAL_NODE_HTTP_PERIOD;
        String httpTimeout = NodeAddViewAction.INITIAL_NODE_HTTP_TIMEOUT;
        String popPeriod = NodeAddViewAction.INITIAL_NODE_POP_PERIOD;
        String popUser = "";
        String popPassword = "";
        String popPort = NodeAddViewAction.INITIAL_NODE_POP_PORT;
        String popTimeout = NodeAddViewAction.INITIAL_NODE_POP_TIMEOUT;
        String smtpPeriod = NodeAddViewAction.INITIAL_NODE_SMTP_PERIOD;
        String smtpPort = NodeAddViewAction.INITIAL_NODE_SMTP_PORT;
        String smtpTimeout = NodeAddViewAction.INITIAL_NODE_SMTP_TIMEOUT;
        String smtpSendAddress = "";
        String smtpCheckPopHost = "";
        String smtpCheckPopUser = "";
        String smtpCheckPopPassword = "";
        String smtpCheckPopPort = NodeAddViewAction.INITIAL_NODE_POP_PORT;
        String smtpCheckPopTimeout = NodeAddViewAction.INITIAL_NODE_POP_TIMEOUT;

        /*  */
        nodename = nodeInfoArray[NodeRegisterUploadModel.NODENAME_NUMBER];
        ipaddress = nodeInfoArray[NodeRegisterUploadModel.IPADDRESS_NUMBER];

        /*
         *
         */
        if (
            (nodeInfoArray[NodeRegisterUploadModel.GROUP_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.GROUP_NUMBER].equals(
                    "")) {
            group = nodeInfoArray[NodeRegisterUploadModel.GROUP_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.ENGINE_ADDRESS_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.ENGINE_ADDRESS_NUMBER]
                .equals("")) {
            engineAddress =
                nodeInfoArray[NodeRegisterUploadModel.ENGINE_ADDRESS_NUMBER];
            logger.info("Set engineAddress : " + engineAddress);
        } else {
            ArrayList list =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();
            engineAddress =
                ((EngineResourceInfo) list.get(0)).getEngineIPaddress();
            logger.info("Default engineAddress set : " + engineAddress);
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.NODE_X_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.NODE_X_NUMBER].equals(
                    "")) {
            nodeX = nodeInfoArray[NodeRegisterUploadModel.NODE_X_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.NODE_Y_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.NODE_Y_NUMBER].equals(
                    "")) {
            nodeY = nodeInfoArray[NodeRegisterUploadModel.NODE_Y_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.NODEKIND_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.NODEKIND_NUMBER]
                .equals("")) {
            nodekind = nodeInfoArray[NodeRegisterUploadModel.NODEKIND_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.PING_PERIOD_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.PING_PERIOD_NUMBER]
                .equals("")) {
            pingPeriod =
                nodeInfoArray[NodeRegisterUploadModel.PING_PERIOD_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.PING_THRESHHOLD_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.PING_THRESHHOLD_NUMBER]
                .equals("")) {
            pingThreshhold =
                nodeInfoArray[NodeRegisterUploadModel.PING_THRESHHOLD_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.SNMP_VERSION_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.SNMP_VERSION_NUMBER]
                .equals("")) {
            snmpVersion =
                nodeInfoArray[NodeRegisterUploadModel.SNMP_VERSION_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.SNMP_PERIOD_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.SNMP_PERIOD_NUMBER]
                .equals("")) {
            snmpPeriod =
                nodeInfoArray[NodeRegisterUploadModel.SNMP_PERIOD_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.SNMP_LEVEL_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.SNMP_LEVEL_NUMBER]
                .equals("")) {
            snmpLevel =
                nodeInfoArray[NodeRegisterUploadModel.SNMP_LEVEL_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.SNMP_ROCOMMUNITY_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.SNMP_ROCOMMUNITY_NUMBER]
                .equals("")) {
            roCommunity =
                nodeInfoArray[NodeRegisterUploadModel.SNMP_ROCOMMUNITY_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.SNMP_RWCOMMUNITY_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.SNMP_RWCOMMUNITY_NUMBER]
                .equals("")) {
            rwCommunity =
                nodeInfoArray[NodeRegisterUploadModel.SNMP_RWCOMMUNITY_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.HTTP_PERIOD_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.HTTP_PERIOD_NUMBER]
                .equals("")) {
            httpPeriod =
                nodeInfoArray[NodeRegisterUploadModel.HTTP_PERIOD_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.HTTP_URL_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.HTTP_URL_NUMBER]
                .equals("")) {
            httpUrl = nodeInfoArray[NodeRegisterUploadModel.HTTP_URL_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.HTTP_TIMEOUT_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.HTTP_TIMEOUT_NUMBER]
                .equals("")) {
            httpTimeout =
                nodeInfoArray[NodeRegisterUploadModel.HTTP_TIMEOUT_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.POP_PERIOD_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.POP_PERIOD_NUMBER]
                .equals("")) {
            popPeriod =
                nodeInfoArray[NodeRegisterUploadModel.POP_PERIOD_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.POP_USER_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.POP_USER_NUMBER]
                .equals("")) {
            popUser = nodeInfoArray[NodeRegisterUploadModel.POP_USER_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.POP_PASSWORD_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.POP_PASSWORD_NUMBER]
                .equals("")) {
            popPassword =
                nodeInfoArray[NodeRegisterUploadModel.POP_PASSWORD_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.POP_PORT_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.POP_PORT_NUMBER]
                .equals("")) {
            popPort = nodeInfoArray[NodeRegisterUploadModel.POP_PORT_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.POP_TIMEOUT_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.POP_TIMEOUT_NUMBER]
                .equals("")) {
            popTimeout =
                nodeInfoArray[NodeRegisterUploadModel.POP_TIMEOUT_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.SMTP_PERIOD_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.SMTP_PERIOD_NUMBER]
                .equals("")) {
            smtpPeriod =
                nodeInfoArray[NodeRegisterUploadModel.SMTP_PERIOD_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.SMTP_PORT_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.SMTP_PORT_NUMBER]
                .equals("")) {
            smtpPort = nodeInfoArray[NodeRegisterUploadModel.SMTP_PORT_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.SMTP_TIMEOUT_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.SMTP_TIMEOUT_NUMBER]
                .equals("")) {
            smtpTimeout =
                nodeInfoArray[NodeRegisterUploadModel.SMTP_TIMEOUT_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.SMTP_SEND_ADDRESS_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.SMTP_SEND_ADDRESS_NUMBER]
                .equals("")) {
            smtpSendAddress =
                nodeInfoArray[NodeRegisterUploadModel.SMTP_SEND_ADDRESS_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_HOST_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_HOST_NUMBER]
                .equals("")) {
            smtpCheckPopHost =
                nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_HOST_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_USER_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_USER_NUMBER]
                .equals("")) {
            smtpCheckPopUser =
                nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_USER_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_PASSWORD_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_PASSWORD_NUMBER]
                .equals("")) {
            smtpCheckPopPassword =
                nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_PASSWORD_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_PORT_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_PORT_NUMBER]
                .equals("")) {
            smtpCheckPopPort =
                nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_PORT_NUMBER];
        }

        if (
            (nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_TINEOUT_NUMBER] != null)
                && !nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_TINEOUT_NUMBER]
                .equals("")) {
            smtpCheckPopTimeout =
                nodeInfoArray[NodeRegisterUploadModel.SMTP_CHECK_POP_TINEOUT_NUMBER];
        }

        /*
         * m[hĎCX^X
         */
        NodeInformation registerNodeInfo = new NodeInformation();

        registerNodeInfo.setNodename(nodename);
        registerNodeInfo.setIpaddress(ipaddress);
        registerNodeInfo.setGroup(group);
        registerNodeInfo.setEngineAddress(engineAddress);
        registerNodeInfo.setNodeX(nodeX);
        registerNodeInfo.setNodeY(nodeY);
        registerNodeInfo.setNodeKind(nodekind);
        registerNodeInfo.setPingPeriod(pingPeriod);
        registerNodeInfo.setPingThreshold(pingThreshhold);
        registerNodeInfo.setSnmpVersion(snmpVersion);
        registerNodeInfo.setSnmpPeriod(snmpPeriod);
        registerNodeInfo.setSnmpLevel(snmpLevel);
        registerNodeInfo.setRoCommunity(roCommunity);
        registerNodeInfo.setRwCommunity(rwCommunity);
        registerNodeInfo.setHttpPeriod(httpPeriod);
        registerNodeInfo.setHttpUrl(httpUrl);
        registerNodeInfo.setHttpTimeout(httpTimeout);
        registerNodeInfo.setPopPeriod(popPeriod);
        registerNodeInfo.setPopUser(popUser);
        registerNodeInfo.setPopPassword(popPassword);
        registerNodeInfo.setPopPort(popPort);
        registerNodeInfo.setPopTimeout(popTimeout);
        registerNodeInfo.setSmtpPeriod(smtpPeriod);
        registerNodeInfo.setSmtpPort(smtpPort);
        registerNodeInfo.setSmtpTimeout(smtpTimeout);
        registerNodeInfo.setSmtpSendAddress(smtpSendAddress);
        registerNodeInfo.setSmtpCheckHost(smtpCheckPopHost);
        registerNodeInfo.setSmtpCheckUser(smtpCheckPopUser);
        registerNodeInfo.setSmtpCheckPassword(smtpCheckPopPassword);
        registerNodeInfo.setSmtpCheckPort(smtpCheckPopPort);
        registerNodeInfo.setSmtpCheckTimeout(smtpCheckPopTimeout);

        return registerNodeInfo;
    }
}
