/*
 * Created on 2003/08/21
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.xmlsocket.action;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.library.ClientFlashInfo;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * Flash XML SocketڑpIPAhXNCAgɕԂ߂̃ANVNXłB
 * iFlash XMLSocketł́Alocalhostւ̐ڑIPAhXł͂Ȃ"localhost"
 *  Kv܂Bj
 *
 * m[hr[pƃm[h}l[WpÃNX̓m[hr[płB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class XmlSocketServerIPAction extends Action {
    /* MO */
    private static Logger logger = null;

    /**
     * XML Socketڑs߂Flash Action Script̃T[oIPAhXԂ܂B
     * iFlash XMLSocketł́Alocalhostւ̐ڑIPAhXł͂Ȃ"localhost"
     * Kv܂Bj
     *
     * @param mapping ActionMapping
     * @param form ActionForm
     * @param request HttpServletRequest
     * @param response HttpServletResponse
     * @return ActionForward ActionForward
     * @throws Exception ُ킪ꍇ
     */
    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
            engineAddress = "localhost";
        }

        /*
        InetAddress localAddress = InetAddress.getLocalHost();
        logger.info(
        "Request Remote IP=" + request.getRemoteAddr() + " Local Address="
        + localAddress.getHostAddress());
        */
        String targetIpAddress = request.getParameter(Preference.IPADDRESS);

        // NCAguEUFlashpp[^Zbg
        ClientFlashInfo clientInfo = new ClientFlashInfo();
        request = clientInfo.getClientFlashInfo(engineAddress, request);
        request.setAttribute(Preference.TARGET_IPADDRESS, targetIpAddress);
        request.setAttribute(
            Preference.REFRESH_TIMER, Preference.REFRESH_TIMER_SHOW);

        // NCAguEUł̃t[ɕtT[oyIPAhXZbg
        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String frameNameforServername = servernamework2.replace('-', '_');
        String convIPAddress = targetIpAddress.replace('.', '_');

        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(
            Preference.FRAME_NAME_AT_SERVER_NAME, frameNameforServername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
