/*
 * Created on 2003/08/24
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.xmlsocket.action;

import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.library.ClientFlashInfo;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * Flash XML SocketڑpIPAhXNCAgɕԂ߂̃ANVNXŁA
 * m[h}l[WpłB
 * NCAgFlash XML Socketłlocalhostւ̐ڑɂẮAIPAhXł͂Ȃ
 * localhostɂȂƐڑłȂ߂ɂ̃ANVoRŃNCAgFlashN܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class XmlSocketServerNodemanagerAction extends Action {
    /* MO */
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response)
        throws EngineConnectException, IOException {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
        }

        try {
            /*
            InetAddress localAddress = InetAddress.getLocalHost();
            logger.info("Engine address : " + engineAddress);
            logger.info(
            "Request Remote IP=" + request.getRemoteAddr()
            + " Local Address=" + localAddress.getHostAddress());
            */
            /*
             * NCAguEUFlash̃p[^Zbg
             */
            ClientFlashInfo clientInfo = new ClientFlashInfo();
            request = clientInfo.getClientFlashInfo(engineAddress, request);
            request.setAttribute(
                Preference.REFRESH_TIMER, Preference.REFRESH_TIMER_SHOW);

            /*
             * NCAguEŨt[ɕtT[o
             */
            String servernamework1 =
                InetAddress.getLocalHost().toString().replace('.', '_');
            String servernamework2 = servernamework1.replace('/', '_');
            String frameNameforServername = servernamework2.replace('-', '_');
            request.setAttribute(
                Preference.FRAME_NAME_AT_SERVER_NAME, frameNameforServername);
            request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);
        } catch (EngineConnectException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        } catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }

        return mapping.findForward(Preference.SUCCESS);
    }
}
