/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.honeyport.thread;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public final class HoneyPortServerControl {
	// MO
	private static Logger logger = null;

	private List tcpThreadList = Collections.synchronizedList(new LinkedList());
	private List udpThreadList = Collections.synchronizedList(new LinkedList());
	
	private HoneyPortServerControl() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	public void startHoneyTCPPortServer(String tcpPortNo, boolean isSetAlarm)
			throws IOException {


		HoneyTCPPortServer tcpServer = new HoneyTCPPortServer();
		tcpThreadList.add(tcpServer);
		tcpServer.startTCPPortScanReceiveServer(Integer
				.parseInt(tcpPortNo), isSetAlarm);

	}

	public void startHoneyUDPPortServer(String udpPortNo, boolean isSetAlarm)
			throws IOException {



		HoneyUDPPortServer udpServer = new HoneyUDPPortServer();
		udpThreadList.add(udpServer);
		udpServer.startUDPPortScanReceiveServer(Integer
				.parseInt(udpPortNo), isSetAlarm);

	}

	public void stopHoneyPortServer() {

		for (int i = 0; i < tcpThreadList.size(); i++) {
			HoneyTCPPortServer tcpServer = (HoneyTCPPortServer) tcpThreadList
					.get(i);
			tcpServer.stopTCPPortScanReceiveServer();
		}
		for (int i = 0; i < udpThreadList.size(); i++) {
			HoneyUDPPortServer udpServer = (HoneyUDPPortServer) udpThreadList
					.get(i);
			udpServer.stopUDPPortScanReceiveServer();
		}
		
	}



	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static HoneyPortServerControl getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final HoneyPortServerControl RESOURCE = new HoneyPortServerControl();
	}
}
