/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.honeyport.thread;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class PortScanMessageQueue {
	/* L[郊Xg */
	private static List portScanQueueList;

	private static final int LIMIT = 100;

	private PortScanMessageQueue() {
		portScanQueueList = Collections.synchronizedList(new LinkedList());
	}

	public synchronized void pushPortScanInfo(final PortScanInfo portScanInfo) {

		if (portScanQueueList.size() > LIMIT) {
			portScanQueueList.remove(0);

		}
		portScanQueueList.add(portScanInfo);

	}

	public synchronized PortScanInfo popPortScanInfo() {
		PortScanInfo portScanInfo = null;

		if (portScanQueueList.size() > 0) {
			portScanInfo = (PortScanInfo) portScanQueueList.get(0);
			portScanQueueList.remove(0);
		}

		return portScanInfo;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static PortScanMessageQueue getInstance() {
		return SingletonResource.PORT_SCAN_MESSAGE_QUEUE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final PortScanMessageQueue PORT_SCAN_MESSAGE_QUEUE = new PortScanMessageQueue();
	}
}
