/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.honeyport.view;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import netjfwatcher.engine.model.action.DatabaseControl;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.honeyport.preference.HoneyPortInfo;
import netjfwatcher.honeyport.preference.HoneyPortScanDefineConfig;
import netjfwatcher.honeyport.thread.HoneyPortServerControl;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

/**
 * Honey Port𐧌䂷ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class HoneyPortScanEditorView extends AbstractEditorNodeView {
	/** View^CgSuffix */
	public static final String TITLE_SUFFIX = "Port Scan";

	public static final String TCP_DISCRIPTION = "tcp";
	public static final String UDP_DISCRIPTION = "udp";
	/* Scroll CompositeTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 400 };

	/* List widthhint */
	private static final int PORT_LIST_WIDTHHINT = 300;

	/* List verticalSpan */
	private static final int PORT_LIST_VERTIALSPAN = 7;

	/* List ItemHeight */
	private static final int PORT_LIST_ITEMHEIGHT = 15;

	private static final String PATTERN_SPACE_SPLIT = "[ \t]"; // 󔒂܂̓^u

	private static final String SPACE = " ";

	private List portList;

	private List checkPortList;

	private HashMap checkPortMap = new HashMap();

	private String selectPortDisc;

	private String selectCheckPortDisc;

	/* Display */
	private Display display;

	/* Logging */
	private static Logger logger;

	private Button honeyPortStartButton;

	private Button honeyPortStopButton;

	private Button setAlarmButton;

	private Button portAddButton;

	private Button portDeleteButton;

	/* eLXg\BackGroundFi[ */
	private Color textBackColor;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public HoneyPortScanEditorView() {
		logger = Logger.getLogger(this.getClass().getName());
		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {

		display = parent.getDisplay();

		/*
		 * ViewCAEg
		 */
		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, true);
		Composite composite0 = new Composite(scrollComposite, SWT.NONE);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL
				| GridData.VERTICAL_ALIGN_FILL));

		GridLayout gridLayout = new GridLayout(3, false);
		Composite composite1 = new Composite(composite0, SWT.NULL);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		honeyPortStartButton = new Button(composite1, SWT.NONE);
		honeyPortStartButton.setText("Start");

		honeyPortStopButton = new Button(composite1, SWT.NONE);
		honeyPortStopButton.setText("Stop");

		setAlarmButton = new Button(composite1, SWT.CHECK);
		setAlarmButton.setText("Set Alarm");

		GridLayout gridLayout2 = new GridLayout(3, false);
		Composite composite2 = new Composite(composite0, SWT.NONE);
		composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite2.setLayout(gridLayout2);

		GridLayout gridLayout3 = new GridLayout(1, false);
		Composite composite3 = new Composite(composite2, SWT.NONE);
		composite3.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite3.setLayout(gridLayout3);

		Label label = new Label(composite3, SWT.NONE);
		label.setText("Port List");
		label.setLayoutData(new GridData());

		portList = new List(composite3, SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL
				| SWT.H_SCROLL);

		GridData data = new GridData(GridData.FILL_BOTH);
		data.horizontalSpan = 1;
		data.verticalSpan = PORT_LIST_VERTIALSPAN;
		data.widthHint = PORT_LIST_WIDTHHINT;
		data.heightHint = portList.getItemHeight() * PORT_LIST_ITEMHEIGHT;
		portList.setLayoutData(data);

		GridLayout gridLayout4 = new GridLayout(1, false);
		Composite composite4 = new Composite(composite2, SWT.NONE);
		composite4.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite4.setLayout(gridLayout4);

		portAddButton = new Button(composite4, SWT.NONE);
		portAddButton.setText(">>");
		gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		portAddButton.setLayoutData(gridData);

		portDeleteButton = new Button(composite4, SWT.NONE);
		portDeleteButton.setText("<<");
		gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		portDeleteButton.setLayoutData(gridData);

		GridLayout gridLayout5 = new GridLayout(1, false);
		Composite composite5 = new Composite(composite2, SWT.NONE);
		composite5.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite5.setLayout(gridLayout5);

		label = new Label(composite5, SWT.NONE);
		label.setText("Check Port List");
		label.setLayoutData(new GridData());

		GridData data2 = new GridData(GridData.FILL_BOTH);
		checkPortList = new List(composite5, SWT.SINGLE | SWT.BORDER
				| SWT.V_SCROLL | SWT.H_SCROLL);

		data2.horizontalSpan = 1;
		data2.verticalSpan = PORT_LIST_VERTIALSPAN;
		data2.widthHint = PORT_LIST_WIDTHHINT;
		data2.heightHint = checkPortList.getItemHeight() * PORT_LIST_ITEMHEIGHT;

		checkPortList.setLayoutData(data2);

		scrollComposite.setContent(composite0);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		setPortList();
		setAlarmButton.setSelection(true);

		honeyPortStartButton.setEnabled(false);
		honeyPortStopButton.setEnabled(false);

		portAddButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				portAddButton.setEnabled(false);
				try {
					String[] portItem = splitPortString(selectPortDisc);
					if (!checkPortMap.containsKey(portItem[0])) {
						checkPortList.add(selectPortDisc);

						checkPortMap.put(portItem[0], portItem[0]);
						honeyPortStartButton.setEnabled(true);
						honeyPortStopButton.setEnabled(false);
					}
				} finally {
					portAddButton.setEnabled(true);
				}

			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		portDeleteButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				portDeleteButton.setEnabled(false);

				try {
					if (checkPortList.getSelectionCount() > 0) {
						String[] portItem = splitPortString(selectCheckPortDisc);
						checkPortList.remove(selectCheckPortDisc);
						checkPortMap.remove(portItem[0]);
					}

				} finally {
					portDeleteButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		portList.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				int index = portList.getSelectionIndex();
				if (index < 0) {
					return;
				}
				if (portList.getItemCount() > 0) {
					selectPortDisc = portList.getItem(index);
				}
			}
		});
		checkPortList.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				int index = checkPortList.getSelectionIndex();
				if (index < 0) {
					return;
				}
				if (checkPortList.getItemCount() > 0) {
					selectCheckPortDisc = checkPortList.getItem(index);
				}

			}
		});

		honeyPortStartButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				if (setAlarmButton.getSelection()) {
					if (!DatabaseControl.getInstance().isDatabaseStart()) {
						MessageDialog.openError(getSite().getShell(), "Error",
								"Not running Database.");
						setAlarmButton.setSelection(false);
					}
				}
				startPortScan(setAlarmButton.getSelection());
				honeyPortStartButton.setEnabled(false);
				honeyPortStopButton.setEnabled(true);
				setAlarmButton.setEnabled(false);

			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		honeyPortStopButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				setAlarmButton.setEnabled(true);
				checkPortList.removeAll();
				checkPortMap.clear();

				HoneyPortServerControl.getInstance().stopHoneyPortServer();
				honeyPortStartButton.setEnabled(false);
				honeyPortStopButton.setEnabled(false);

			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

	}

	private void startPortScan(boolean isSetAlarm) {

		Iterator it = null;
		for (it = checkPortMap.keySet().iterator(); it.hasNext();) {
			String portInfo = (String) it.next();
			if (portInfo == null) {
				break;
			}

			try {
				String[] portNoKind = splitPortKindString(portInfo);
				if (portNoKind.length != 2) {
					return;
				}
				if (portNoKind[1].equals(TCP_DISCRIPTION)) {
					HoneyPortServerControl.getInstance()
							.startHoneyTCPPortServer(portNoKind[0], isSetAlarm);
				} else if (portNoKind[1].equals(UDP_DISCRIPTION)) {
					HoneyPortServerControl.getInstance()
							.startHoneyUDPPortServer(portNoKind[0], isSetAlarm);
				}
			} catch (IOException ex) {
				MessageDialog.openError(getEditorSite().getShell(), "Error", ex
						.getMessage()
						+ " " + (String) checkPortMap.get(portInfo));

			}

		}

	}

	/*
	 * |[gԍALq擾܂B
	 */
	private String[] splitPortString(String str) {

		Pattern pattern;
		String[] item;

		pattern = Pattern.compile(PATTERN_SPACE_SPLIT);
		item = pattern.split(str, 2);

		return item;

	}

	/*
	 * |[gʏ擾܂B
	 * 
	 */
	private String[] splitPortKindString(String str) {

		Pattern pattern;
		String[] item;

		pattern = Pattern.compile("/");
		item = pattern.split(str, 2);

		return item;

	}

	private void setPortList() {
		Map portMap = HoneyPortScanDefineConfig.getInstance()
				.getResourceFileParse().getPortInfoHashMap();
		for (Iterator it = portMap.keySet().iterator(); it.hasNext();) {
			String key = (String) it.next();
			HoneyPortInfo portInfo = (HoneyPortInfo) portMap.get(key);
			portList.add(key + SPACE + portInfo.getPortDiscription());
		}

	}

	/**
	 * Xe[^XC\Zbg܂B
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/*
		 * InterfaceԂɍ킹ĕFZbgpColorIuWFNg CX^Xj
		 */
		if (textBackColor != null) {
			textBackColor.dispose();
		}

	}

}
