/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.honeyport.view;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.honeyport.thread.PortScanInfo;
import netjfwatcher.honeyport.thread.PortScanMessageQueue;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class HoneyPortScanTableTimerProcessor extends AbstractTableView
		implements Runnable {

	public static final int TIMER = 1000;

	private Display display;

	private Table portScanTable;

	private int count = 0;

	private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	public HoneyPortScanTableTimerProcessor() {
		// nothing
	}

	public void run() {

		if (!display.isDisposed() && !portScanTable.isDisposed()
				&& portScanTable.isVisible()) {

			PortScanInfo portScanInfo = PortScanMessageQueue.getInstance()
					.popPortScanInfo();

			while (portScanInfo != null) {

				String[] portScanString = new String[HoneyPortScanTableViewLabelProvider.PORT_SCAN_TABLE_ARRAY_COUNT];

				count++;

				portScanString[HoneyPortScanTableViewLabelProvider.NO] = Integer
						.toString(count);
				portScanString[HoneyPortScanTableViewLabelProvider.IP_ADDRESS] = portScanInfo
						.getIpAddress();
				portScanString[HoneyPortScanTableViewLabelProvider.PORT] = Integer
						.toString(portScanInfo.getPort())
						+ "/" + portScanInfo.getPortKind();
				Date startDate = portScanInfo.getStartDate();
				if (startDate != null) {
					portScanString[HoneyPortScanTableViewLabelProvider.START_DATE] = dateformat
							.format(startDate);
				} else {
					portScanString[HoneyPortScanTableViewLabelProvider.START_DATE] = "";
				}
				Date checkDate = portScanInfo.getCheckDate();
				if (checkDate != null) {
					portScanString[HoneyPortScanTableViewLabelProvider.CHECK_DATE] = dateformat
							.format(checkDate);
				} else {
					portScanString[HoneyPortScanTableViewLabelProvider.CHECK_DATE] = "";
				}
				portScanString[HoneyPortScanTableViewLabelProvider.CHECK_COUNT] = Integer
						.toString(portScanInfo.getCheckCount());
				/*
				 * e[usɃf[^ǉE\
				 */
				TableItem tableItem = new TableItem(portScanTable, SWT.NULL);
				tableItem.setData(portScanString);
				tableItem.setText(portScanString);

				portScanInfo = PortScanMessageQueue.getInstance()
						.popPortScanInfo();
				if (portScanInfo == null) {
					/* e[uJ0Ń\[g\ */
					sortIntegerTable(portScanTable, 0, true);
				}
			}

			// ^C}[p
			display.timerExec(TIMER, this);
		}
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static HoneyPortScanTableTimerProcessor getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * TimersDisplayZbg܂B
	 * 
	 * @param display
	 *            TimersDisplay
	 */
	public void setDisplay(Display display) {
		this.display = display;
	}

	/**
	 * XVe[uZbg܂B
	 * 
	 * @param table
	 *            XVe[u
	 */
	public void setTable(Table table) {
		this.portScanTable = table;
	}

	protected void setResizedTableColumnWidth() {
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final HoneyPortScanTableTimerProcessor RESOURCE = new HoneyPortScanTableTimerProcessor();
	}
}
