/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.thread;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;


public final class PortScanBusyCheck {

    private static Map busyMap = Collections.synchronizedMap(new HashMap());

    private PortScanBusyCheck() {
    }


    public synchronized boolean getArbitrationExec(final String ipAddress) {
        boolean isBusy = false;

        if (busyMap.containsKey(ipAddress)) {
            return isBusy;
        }

        isBusy = true;
        busyMap.put(ipAddress, null);

        return isBusy;
    }


    public synchronized void release(final String ipAddress) {
        busyMap.remove(ipAddress);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static PortScanBusyCheck getInstance() {
        return SingletonAboutMessage.INSTANCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final PortScanBusyCheck INSTANCE = new PortScanBusyCheck();
    }
}
