/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.view;

import java.util.logging.Logger;

import netjfwatcher.engine.model.action.ListenerNodeListTree;
import netjfwatcher.engine.nodemaneger.list.NodeListTreeView;
import netjfwatcher.portscan.view.action.MenuActionControl;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;



/**
 * m[hTree\ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class PortScanNodeTreeView extends NodeListTreeView {

    /* MO */
    private static Logger logger = null;


    /**
     * m[hTree\ViewNXCX^X𐶐܂B
     *
     */
    public PortScanNodeTreeView() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * f[^x[Xm[hĎ񃊃XgǂݍTree\
     * ܂B
     *
     */
    protected void initShow() {
        /* ((ActionReloadNodeTreeDatabase) actionNodeTree.
         * actionReloadNodeTreeDatabase()).setNodeTree();
        */
    }

    /**
     * ReLXgj[𐶐܂B
     *
     */
    public void createContextMenu() {
        /* j[}l[W */
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);

        /* j[Xi[Zbg */
        mm.addMenuListener(
            new IMenuListener() {
                public void menuAboutToShow(IMenuManager manager) {
                    fillContextMenu(manager);
                }
            });

        Menu menu = mm.createContextMenu(nodeListTreeViewer.getControl());
        nodeListTreeViewer.getControl().setMenu(menu);
        getSite().registerContextMenu(mm, nodeListTreeViewer);
    }

    /**
     * ANV̏ƂToolBarݒ肵܂B
     *
     */
    protected void setToolBarActions() {
        /* ToolBarݒ */
        IToolBarManager toolBarManager =
            getViewSite().getActionBars().getToolBarManager();

        MenuActionControl.getInstance().setToolBarActions(toolBarManager, actionNodeTree);

    }

    /**
     * j[o[ݒ肵܂B
     * preWindowOpenɌĂ΂܂B
     * m[hTreẽm[hIĂꍇƑIĂȂꍇ
     * j[ς܂B
     *
     * @param manager IMenuManager
     */
    protected void fillContextMenu(IMenuManager manager) {
    	MenuActionControl.getInstance().setContextMenu(nodeListTreeViewer, actionNodeTree, manager);
    }

    

    /**
     * m[hTree View̑IXi[ݒ肵܂B
     *
     */
    protected void setupNodeTreeViewListener() {
        /*
         * Node Tree ViewɃXi[o^
         * Xi[̏ƂẮA
         * e[uViewɃtB[hꗗőIGg͒lƂĐݒ
         *
         */
        nodeListTreeViewer.addSelectionChangedListener(
            new ListenerNodeListTree(false));
    }
}
