/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.view;

import java.util.List;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.snmpmanager.trap.TrapReceiveMessageQueue;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;



/**
 * TrapMf[^i[L[IɊĎAe[u\NX
 * łB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class PortScanTableTimerProcessor extends AbstractTableView
    implements Runnable {

    public static final int TIMER = 1000;


    private Display display;


    private Table portScanTable;


    public PortScanTableTimerProcessor() {
        // nothing
    }


    public void run() {

        List tarpInfoArrayList =
            (List) TrapReceiveMessageQueue.getInstance().popTrapData();

        while (tarpInfoArrayList != null) {
            String[] trapInfo = (String[]) tarpInfoArrayList.get(0);

            /*
             * TrapMe[usɃf[^ǉE\
             */
            TableItem tableItem = new TableItem(portScanTable, SWT.NULL);
            tableItem.setData(trapInfo);
            tableItem.setText(trapInfo);

            /* TrapMe[uJ0Ń\[g\ */
            sortIntegerTable(portScanTable, 0, true);
            tarpInfoArrayList =
                (List) TrapReceiveMessageQueue.getInstance().popTrapData();
        }

        // ^C}[p
        display.timerExec(TIMER, this);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static PortScanTableTimerProcessor getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * TimersDisplayZbg܂B
     *
     * @param display TimersDisplay
     */
    public void setDisplay(Display display) {
        this.display = display;
    }

    /**
     * XVe[uZbg܂B
     *
     * @param table XVe[u
     */
    public void setTable(Table table) {
        this.portScanTable = table;
    }

	protected void setResizedTableColumnWidth() {
	}
    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final PortScanTableTimerProcessor RESOURCE =
            new PortScanTableTimerProcessor();
    }
}
