/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.view;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.portscan.actions.ActionBuilderPortScanTable;
import netjfwatcher.snmpmanager.model.ActionBuilderTrapReceiveTable;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;

public class PortScanTableView extends AbstractTableView {

	/* Port Scan f[^\^C}[ */
	private static final int PORT_SCAN_TABLE_TIMER = 1000;

	private static boolean isCol0Direction = false;

	private static boolean isCol1Direction = true;

	private static boolean isCol2Direction = true;

	private static boolean isCol3Direction = true;

	private static boolean isCol4Direction = true;

	private static boolean isCol5Direction = true;

	private static boolean isCol6Direction = true;

	private static boolean isCol7Direction = true;

	private static boolean isCol8Direction = true;

	private static boolean isCol9Direction = true;

	private TableColumn col0;

	private TableColumn col1;

	private TableColumn col2;

	private TableColumn col3;

	private TableColumn col4;

	private TableColumn col5;

	private TableColumn col6;

	private TableColumn col7;

	private TableColumn col8;

	private TableColumn col9;

	/* J */
	private static final float COLUMN0_NO = 0.03f;

	private static final float COLUMN1_IPADDRESS = 0.1f;

	private static final float COLUMN2_NODE_NAME = 0.2f;

	private static final float COLUMN3_GROUP = 0.1f;

	private static final float COLUMN4_PORT = 0.1f;

	private static final float COLUMN5_PERIOD = 0.05f;

	private static final float COLUMN6_START_DATE = 0.1f;

	private static final float COLUMN7_CHECK_DATE = 0.1f;

	private static final float COLUMN8_CHECK_COUNT = 0.1f;

	private static final float COLUMN9_NG_COUNT = 0.1f;

	private Table table;

	private TableViewer viewer;

	private PortScanTableTimerProcessor timerProcessor;

	private SubStatusLineManager statusLineManager;

	private ActionBuilderPortScanTable actionTrapReceiveTableBuilder;

	/* Display */
	private Display display;

	/**
	 * ANV\z܂B
	 * 
	 * @return actionBuilder ActionBuilder
	 */
	public ActionBuilderPortScanTable getActionBuilder() {
		return actionTrapReceiveTableBuilder;
	}

	/**
	 * tH[JXZbgꂽ̏łB
	 */
	public void setFocus() {
		setStatusLine();
	}

	/**
	 * e[uViewi\`̌ځjԂ܂B
	 * 
	 * 
	 * @return viewer TableViewer
	 */
	public TableViewer getViewer() {
		return viewer;
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		display = parent.getDisplay();

		/* TrapMe[u𐶐 */
		createTable(parent);
		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		viewer.setContentProvider(new PortScanTableViewContentProvider());

		/* xEtHgȂǂݒ */
		viewer.setLabelProvider(new PortScanTableViewLabelProvider());

		/* ANV\z */
		actionTrapReceiveTableBuilder = new ActionBuilderPortScanTable(display,
				viewer, table, statusLineManager);

		/* ReLXgj[AZbg */
		createContextMenu();

		/* ANV̏ */
		initActions();

		startTimer();
	}

	private int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN0_NO);
	}

	private int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN1_IPADDRESS);
	}

	private int computeCol2Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN2_NODE_NAME);
	}

	private int computeCol3Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN3_GROUP);
	}

	private int computeCol4Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN4_PORT);
	}

	private int computeCol5Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN5_PERIOD);
	}

	private int computeCol6Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN6_START_DATE);
	}

	private int computeCol7Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN7_CHECK_DATE);
	}

	private int computeCol8Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN8_CHECK_COUNT);
	}

	private int computeCol9Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN9_NG_COUNT);
	}

	/**
	 * e[u𐶐܂B e[ůeJwb_[̃^CgAJZbg܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	private void createTable(Composite parent) {
		setStatusLine();

		table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);

		col0 = new TableColumn(table, SWT.LEFT);
		col0
				.setText(PortScanTableViewLabelProvider.COLUMNS[PortScanTableViewLabelProvider.NO]);
		col0.setWidth(computeCol0Width());

		col1 = new TableColumn(table, SWT.LEFT);
		col1
				.setText(PortScanTableViewLabelProvider.COLUMNS[PortScanTableViewLabelProvider.IP_ADDRESS]);
		col1.setWidth(computeCol1Width());

		col2 = new TableColumn(table, SWT.LEFT);
		col2
				.setText(PortScanTableViewLabelProvider.COLUMNS[PortScanTableViewLabelProvider.NODE_NAME]);
		col2.setWidth(computeCol1Width());

		col3 = new TableColumn(table, SWT.LEFT);
		col3
				.setText(PortScanTableViewLabelProvider.COLUMNS[PortScanTableViewLabelProvider.GROUP]);
		col3.setWidth(computeCol1Width());

		col4 = new TableColumn(table, SWT.LEFT);
		col4
				.setText(PortScanTableViewLabelProvider.COLUMNS[PortScanTableViewLabelProvider.PORT]);
		col4.setWidth(computeCol1Width());

		col5 = new TableColumn(table, SWT.LEFT);
		col5
				.setText(PortScanTableViewLabelProvider.COLUMNS[PortScanTableViewLabelProvider.PERIOD]);
		col5.setWidth(computeCol1Width());

		col6 = new TableColumn(table, SWT.LEFT);
		col6
				.setText(PortScanTableViewLabelProvider.COLUMNS[PortScanTableViewLabelProvider.START_DATE]);
		col6.setWidth(computeCol6Width());

		col7 = new TableColumn(table, SWT.LEFT);
		col7
				.setText(PortScanTableViewLabelProvider.COLUMNS[PortScanTableViewLabelProvider.CHECK_DATE]);
		col7.setWidth(computeCol7Width());
		col8 = new TableColumn(table, SWT.LEFT);
		col8
				.setText(PortScanTableViewLabelProvider.COLUMNS[PortScanTableViewLabelProvider.CHECK_COUNT]);
		col8.setWidth(computeCol8Width());
		col9 = new TableColumn(table, SWT.LEFT);
		col9
				.setText(PortScanTableViewLabelProvider.COLUMNS[PortScanTableViewLabelProvider.NG_COUNT]);
		col9.setWidth(computeCol9Width());

		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
				.addControlListener(new ControlListener() {

					public void controlMoved(ControlEvent event) {
					}

					public void controlResized(ControlEvent event) {
						setResizedTableColumnWidth();
					}
				});

		col0.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				/* J\[gA\[gێ */
				isCol0Direction = sortIntegerTable(table,
						PortScanTableViewLabelProvider.NO, isCol0Direction);
			}
		});

		col1.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol1Direction = sortTable(table,
						PortScanTableViewLabelProvider.IP_ADDRESS,
						isCol1Direction);
			}
		});

		col2.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol2Direction = sortTable(table,
						PortScanTableViewLabelProvider.NODE_NAME,
						isCol2Direction);
			}
		});

		col3.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol3Direction = sortTable(table,
						PortScanTableViewLabelProvider.GROUP, isCol3Direction);
			}
		});

		col4.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol4Direction = sortTable(table,
						PortScanTableViewLabelProvider.PORT, isCol4Direction);
			}
		});

		col5.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol5Direction = sortTable(table,
						PortScanTableViewLabelProvider.PERIOD, isCol5Direction);
			}
		});

		col6.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol6Direction = sortTable(table,
						PortScanTableViewLabelProvider.START_DATE,
						isCol6Direction);
			}
		});
		col7.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol6Direction = sortTable(table,
						PortScanTableViewLabelProvider.CHECK_DATE,
						isCol7Direction);
			}
		});
		col8.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol6Direction = sortTable(table,
						PortScanTableViewLabelProvider.CHECK_COUNT,
						isCol8Direction);
			}
		});
		col9.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol6Direction = sortTable(table,
						PortScanTableViewLabelProvider.NG_COUNT,
						isCol9Direction);
			}
		});
	}

	protected void setResizedTableColumnWidth() {
		/*
		 * e[u\Ԃł΃e[uJZbg
		 */
		if (getSite().getPage().isPartVisible(getSite().getPart())
				&& getSite().getShell() != null) {
			if (getSite().getShell().getSize() != null) {
				col0.setWidth(computeCol0Width());
				col1.setWidth(computeCol1Width());
				col2.setWidth(computeCol2Width());
				col3.setWidth(computeCol3Width());
				col4.setWidth(computeCol4Width());
				col5.setWidth(computeCol5Width());
				col6.setWidth(computeCol5Width());
				col7.setWidth(computeCol5Width());
				col8.setWidth(computeCol5Width());
				col9.setWidth(computeCol5Width());

			}
		}

	}

	/**
	 * TrapMe[ũj[o[𐶐܂B preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		manager.add(getActionBuilder().getActionRefreshPortScanTable());

	}

	private void createContextMenu() {
		/* j[}l[W */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[Xi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/* ReLXgj[̐AZbg */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}

	private void initActions() {
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		toolBarManager.add(getActionBuilder().getActionRefreshPortScanTable());

	}

	/*
	 * Xe[^XC\s܂B TrapMThread̓Ԃ\܂B
	 */
	private void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);

	}

	private void startTimer() {

		PortScanTableTimerProcessor.getInstance().setDisplay(display);
		PortScanTableTimerProcessor.getInstance().setTable(table);
		timerProcessor = PortScanTableTimerProcessor.getInstance();
		display.timerExec(PORT_SCAN_TABLE_TIMER, timerProcessor);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/* TrapMf[^\^C}[~ */
		display.timerExec(ActionBuilderTrapReceiveTable.TIMER_STOP,
				timerProcessor);
	}
}
