/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.commons.lang.builder.ToStringStyle;

public class ToStringBuilder {
    private static ToStringStyle defaultStyle = ToStringStyle.DEFAULT_STYLE;
    private final StringBuffer buffer;
    private final ToStringStyle style;
    private final Object object;

    public ToStringBuilder(Object object) {
        this(object, ToStringBuilder.getDefaultStyle(), null);
    }

    public ToStringBuilder(Object object, ToStringStyle style) {
        this(object, style, null);
    }

    public ToStringBuilder(Object object, ToStringStyle style, StringBuffer buffer) {
        if (object == null) {
            throw new IllegalArgumentException("The object to create a toString for must not be null");
        }
        if (style == null) {
            style = ToStringBuilder.getDefaultStyle();
        }
        if (buffer == null) {
            buffer = new StringBuffer(512);
        }
        this.buffer = buffer;
        this.style = style;
        this.object = object;
        style.appendStart(buffer, object);
    }

    public static ToStringStyle getDefaultStyle() {
        return defaultStyle;
    }

    public static void setDefaultStyle(ToStringStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("The style must not be null");
        }
        defaultStyle = style;
    }

    public static String reflectionToString(Object object) {
        return ToStringBuilder.reflectionToString(object, null, false, null);
    }

    public static String reflectionToString(Object object, ToStringStyle style) {
        return ToStringBuilder.reflectionToString(object, style, false, null);
    }

    public static String reflectionToString(Object object, ToStringStyle style, boolean outputTransients) {
        return ToStringBuilder.reflectionToString(object, style, outputTransients, null);
    }

    public static String reflectionToString(Object object, ToStringStyle style, boolean outputTransients, Class reflectUpToClass) {
        if (object == null) {
            throw new IllegalArgumentException("The object must not be null");
        }
        if (style == null) {
            style = ToStringBuilder.getDefaultStyle();
        }
        ToStringBuilder builder = new ToStringBuilder(object, style);
        Class<?> clazz = object.getClass();
        ToStringBuilder.reflectionAppend(object, clazz, builder, outputTransients);
        while (clazz.getSuperclass() != null && clazz != reflectUpToClass) {
            clazz = clazz.getSuperclass();
            ToStringBuilder.reflectionAppend(object, clazz, builder, outputTransients);
        }
        return builder.toString();
    }

    private static void reflectionAppend(Object object, Class clazz, ToStringBuilder builder, boolean useTransients) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        Field.setAccessible(fields, true);
        int i = 0;
        while (i < fields.length) {
            AccessibleObject f = fields[i];
            if (!(((Field)f).getName().indexOf(36) != -1 || !useTransients && Modifier.isTransient(((Field)f).getModifiers()) || Modifier.isStatic(((Field)f).getModifiers()))) {
                try {
                    builder.append(((Field)f).getName(), ((Field)f).get(object));
                }
                catch (IllegalAccessException ex) {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
            }
            ++i;
        }
    }

    public ToStringBuilder appendSuper(String superToString) {
        if (superToString != null) {
            this.style.appendSuper(this.buffer, superToString);
        }
        return this;
    }

    public ToStringBuilder appendToString(String toString) {
        if (toString != null) {
            this.style.appendToString(this.buffer, toString);
        }
        return this;
    }

    public ToStringBuilder append(Object object) {
        this.style.append(this.buffer, null, object, null);
        return this;
    }

    public ToStringBuilder append(String fieldName, Object object) {
        this.style.append(this.buffer, fieldName, object, null);
        return this;
    }

    public ToStringBuilder append(String fieldName, Object object, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, object, new Boolean(fullDetail));
        return this;
    }

    public ToStringBuilder append(long value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder append(String fieldName, long value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder append(int value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder append(String fieldName, int value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder append(short value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder append(String fieldName, short value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder append(char value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder append(String fieldName, char value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder append(byte value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder append(String fieldName, byte value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder append(double value) {
        this.style.append(this.buffer, null, value);
        return this;
    }

    public ToStringBuilder append(String fieldName, double value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder append(float value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder append(String fieldName, float value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder append(boolean value) {
        this.style.append(this.buffer, null, value);
        return this;
    }

    public ToStringBuilder append(String fieldName, boolean value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder append(Object[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, Object[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, Object[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, new Boolean(fullDetail));
        return this;
    }

    public ToStringBuilder append(long[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, long[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, long[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, new Boolean(fullDetail));
        return this;
    }

    public ToStringBuilder append(int[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, int[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, int[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, new Boolean(fullDetail));
        return this;
    }

    public ToStringBuilder append(short[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, short[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, short[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, new Boolean(fullDetail));
        return this;
    }

    public ToStringBuilder append(char[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, char[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, char[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, new Boolean(fullDetail));
        return this;
    }

    public ToStringBuilder append(byte[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, byte[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, byte[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, new Boolean(fullDetail));
        return this;
    }

    public ToStringBuilder append(double[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, double[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, double[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, new Boolean(fullDetail));
        return this;
    }

    public ToStringBuilder append(float[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, float[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, float[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, new Boolean(fullDetail));
        return this;
    }

    public ToStringBuilder append(boolean[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, boolean[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName, boolean[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, new Boolean(fullDetail));
        return this;
    }

    public ToStringStyle getStyle() {
        return this.style;
    }

    public StringBuffer getStringBuffer() {
        return this.buffer;
    }

    public String toString() {
        this.style.appendEnd(this.buffer, this.object);
        return this.buffer.toString();
    }
}

