/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.commons.lang.reflect.ReflectionException;
import org.apache.commons.lang.reflect.ReflectionUtils;

public class FieldUtils {
    public static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    static /* synthetic */ Class class$java$lang$Object;

    public static Field getField(Class cls, String fieldName) {
        return FieldUtils.getField(cls, fieldName, false);
    }

    public static Field getField(Class cls, String fieldName, boolean breakScope) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("The field name must not be null");
        }
        try {
            Class acls = cls;
            Field match = null;
            while (acls != null && acls != (class$java$lang$Object == null ? FieldUtils.class$("java.lang.Object") : class$java$lang$Object)) {
                try {
                    Field field = acls.getDeclaredField(fieldName);
                    if (!Modifier.isPublic(field.getModifiers())) {
                        field.setAccessible(breakScope);
                        return field;
                    }
                    if (!breakScope) {
                        throw new IllegalAccessException("The field '" + fieldName + "' was found, but it's scope prevents direct access by reflection");
                    }
                    field.setAccessible(true);
                    match = field;
                    break;
                }
                catch (NoSuchFieldException ex) {
                    acls = acls.getSuperclass();
                }
            }
            Class<?>[] ints = cls.getInterfaces();
            int i = 0;
            while (i < ints.length) {
                try {
                    Field field = ints[i].getField(fieldName);
                    return field;
                }
                catch (NoSuchFieldException ex) {
                    ++i;
                }
            }
            if (match != null) {
                return match;
            }
            throw new NoSuchFieldException("The field '" + fieldName + "' could not be found");
        }
        catch (ReflectionException ex) {
            throw ex;
        }
        catch (LinkageError ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting field", cls.getName(), null, fieldName), ex);
        }
        catch (Exception ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting field", cls.getName(), null, fieldName), ex);
        }
    }

    public static Field getFieldExact(Class cls, String fieldName) {
        return FieldUtils.getFieldExact(cls, fieldName, false);
    }

    public static Field getFieldExact(Class cls, String fieldName, boolean breakScope) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("The field name must not be null");
        }
        try {
            Field field = cls.getDeclaredField(fieldName);
            if (!Modifier.isPublic(field.getModifiers())) {
                if (breakScope) {
                    field.setAccessible(true);
                } else {
                    throw new IllegalAccessException("The field '" + fieldName + "' was found, but it's scope prevents direct access by reflection");
                }
            }
            return field;
        }
        catch (ReflectionException ex) {
            throw ex;
        }
        catch (LinkageError ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting field", cls.getName(), null, fieldName), ex);
        }
        catch (Exception ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting field", cls.getName(), null, fieldName), ex);
        }
    }

    public static Object getStaticFieldValue(Field field) {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("The field '" + field.getName() + "' is not static");
        }
        return FieldUtils.getFieldValue(field, (Object)null, false);
    }

    public static Object getStaticFieldValue(Field field, boolean breakScope) {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("The field '" + field.getName() + "' is not static");
        }
        return FieldUtils.getFieldValue(field, (Object)null, breakScope);
    }

    public static Object getFieldValue(Field field, Object object) {
        return FieldUtils.getFieldValue(field, object, false);
    }

    public static Object getFieldValue(Field field, Object object, boolean breakScope) {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        try {
            if (breakScope && !Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (ReflectionException ex) {
            throw ex;
        }
        catch (LinkageError ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting field value", field.getDeclaringClass().getName(), null, field.getName()), ex);
        }
        catch (Exception ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting field value", field.getDeclaringClass().getName(), null, field.getName()), ex);
        }
    }

    public static Object getStaticFieldValue(Class cls, String fieldName) {
        return FieldUtils.getStaticFieldValue(cls, fieldName, false);
    }

    public static Object getStaticFieldValue(Class cls, String fieldName, boolean breakScope) {
        try {
            Field field = FieldUtils.getField(cls, fieldName, breakScope);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new NoSuchMethodException("The field '" + fieldName + "' is not static");
            }
            return FieldUtils.getStaticFieldValue(field, breakScope);
        }
        catch (ReflectionException ex) {
            throw ex;
        }
        catch (LinkageError ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting field value", cls.getName(), null, fieldName), ex);
        }
        catch (Exception ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting field value", cls.getName(), null, fieldName), ex);
        }
    }

    public static Object getStaticFieldValueExact(Class cls, String fieldName) {
        return FieldUtils.getStaticFieldValueExact(cls, fieldName, false);
    }

    public static Object getStaticFieldValueExact(Class cls, String fieldName, boolean breakScope) {
        try {
            Field field = FieldUtils.getFieldExact(cls, fieldName, breakScope);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new NoSuchMethodException("The field '" + fieldName + "' is not static");
            }
            return FieldUtils.getStaticFieldValue(field, breakScope);
        }
        catch (ReflectionException ex) {
            throw ex;
        }
        catch (LinkageError ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting field value", cls.getName(), null, fieldName), ex);
        }
        catch (Exception ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting field value", cls.getName(), null, fieldName), ex);
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        return FieldUtils.getFieldValue(object, fieldName, false);
    }

    public static Object getFieldValue(Object object, String fieldName, boolean breakScope) {
        Field field = FieldUtils.getField(object.getClass(), fieldName, breakScope);
        return FieldUtils.getFieldValue(field, object, breakScope);
    }

    public static Object getFieldValueExact(Object object, String fieldName) {
        return FieldUtils.getFieldValueExact(object, fieldName, false);
    }

    public static Object getFieldValueExact(Object object, String fieldName, boolean breakScope) {
        Field field = FieldUtils.getFieldExact(object.getClass(), fieldName, breakScope);
        return FieldUtils.getFieldValue(field, object, breakScope);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

