/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.time;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;

public class CalendarUtils {
    public static final int SEMI_MONTH = 1001;
    private static final int[][] fields = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, {0}};
    private static DateFormat[] dateFormats = new DateFormat[]{new SimpleDateFormat("M/dd/yy h:mm:ss z"), new SimpleDateFormat("MMM d, yyyy h:mm a"), new SimpleDateFormat("h:mm z")};
    public static final int RANGE_WEEK_SUNDAY = 1;
    public static final int RANGE_WEEK_MONDAY = 2;
    public static final int RANGE_WEEK_RELATIVE = 3;
    public static final int RANGE_WEEK_CENTER = 4;
    public static final int RANGE_MONTH_SUNDAY = 5;
    public static final int RANGE_MONTH_MONDAY = 6;

    public static Date round(Date val, int field) {
        GregorianCalendar gval = new GregorianCalendar();
        gval.setTime(val);
        CalendarUtils.modify(gval, field, true);
        return gval.getTime();
    }

    public static Calendar round(Calendar val, int field) {
        Calendar rounded = (Calendar)val.clone();
        CalendarUtils.modify(rounded, field, true);
        return rounded;
    }

    public static Date round(Object val, int field) {
        if (val instanceof Date) {
            return CalendarUtils.round((Date)val, field);
        }
        if (val instanceof Calendar) {
            return CalendarUtils.round((Calendar)val, field).getTime();
        }
        throw new ClassCastException("Could not round " + val);
    }

    public static Date trunc(Date val, int field) {
        GregorianCalendar gval = new GregorianCalendar();
        gval.setTime(val);
        CalendarUtils.modify(gval, field, false);
        return gval.getTime();
    }

    public static Calendar trunc(Calendar val, int field) {
        Calendar truncated = (Calendar)val.clone();
        CalendarUtils.modify(truncated, field, false);
        return truncated;
    }

    public static Date trunc(Object val, int field) {
        if (val instanceof Date) {
            return CalendarUtils.trunc((Date)val, field);
        }
        if (val instanceof Calendar) {
            return CalendarUtils.trunc((Calendar)val, field).getTime();
        }
        throw new ClassCastException("Could not trunc " + val);
    }

    private static void modify(Calendar val, int field, boolean round) {
        boolean roundUp = false;
        int i = 0;
        while (i < fields.length) {
            int j = 0;
            while (j < fields[i].length) {
                if (fields[i][j] == field) {
                    if (round && roundUp) {
                        if (field == 1001) {
                            if (val.get(5) == 1) {
                                val.add(5, 15);
                            } else {
                                val.add(5, -15);
                                val.add(2, 1);
                            }
                        } else {
                            val.add(fields[i][0], 1);
                        }
                    }
                    return;
                }
                ++j;
            }
            int offset = 0;
            boolean offsetSet = false;
            switch (field) {
                case 1001: {
                    if (fields[i][0] != 5) break;
                    offset = val.get(5) - 1;
                    if (offset >= 15) {
                        offset -= 15;
                    }
                    roundUp = offset > 7;
                    offsetSet = true;
                    break;
                }
                case 9: {
                    if (fields[i][0] != 10) break;
                    offset = val.get(10);
                    if (offset >= 12) {
                        offset -= 12;
                    }
                    roundUp = offset > 6;
                    offsetSet = true;
                }
            }
            if (!offsetSet) {
                int min = val.getActualMinimum(fields[i][0]);
                int max = val.getActualMaximum(fields[i][0]);
                offset = val.get(fields[i][0]) - min;
                roundUp = offset > (max - min) / 2;
            }
            val.add(fields[i][0], -offset);
            ++i;
        }
        throw new RuntimeException("We do not support that field.");
    }

    public static Calendar parse(String original) {
        return CalendarUtils.parse(original, Locale.getDefault());
    }

    public static Calendar parse(String original, Locale locale) {
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        String value = original.toLowerCase().trim();
        Calendar now = Calendar.getInstance();
        if (value.endsWith(" ago")) {
            int start = (value = value.substring(0, value.length() - 4)).indexOf(" ");
            if (start < 0) {
                throw new RuntimeException("Could not find space in between value and unit");
            }
            String unit = value.substring(start + 1);
            value = value.substring(0, start);
            int val = 0;
            val = value.equals("a") || value.equals("an") ? 1 : Integer.parseInt(value);
            if (unit.equals("milliseconds") || unit.equals("millisecond")) {
                now.add(14, -val);
            } else if (unit.equals("seconds") || unit.equals("second")) {
                now.add(13, -val);
            } else if (unit.equals("minutes") || unit.equals("minute")) {
                now.add(12, -val);
            } else if (unit.equals("hours") || unit.equals("hour")) {
                now.add(10, -val);
            } else if (unit.equals("days") || unit.equals("day")) {
                now.add(5, -val);
            } else if (unit.equals("weeks") || unit.equals("week")) {
                now.add(5, -val * 7);
            } else if (unit.equals("fortnights") || unit.equals("fortnight")) {
                now.add(5, -val * 14);
            } else if (unit.equals("months") || unit.equals("month")) {
                now.add(2, -val);
            } else if (unit.equals("years") || unit.equals("year")) {
                now.add(1, -val);
            } else {
                throw new RuntimeException("We do not understand that many units ago");
            }
            return now;
        }
        if (value.startsWith("last ")) {
            value = value.substring(5);
            String[] strings = symbols.getWeekdays();
            int i = 0;
            while (i < strings.length) {
                if (value.equalsIgnoreCase(strings[i])) {
                    int daysAgo = now.get(7) - i;
                    if (daysAgo <= 0) {
                        daysAgo += 7;
                    }
                    now.add(5, -daysAgo);
                    return now;
                }
                ++i;
            }
            strings = symbols.getMonths();
            int i2 = 0;
            while (i2 < strings.length) {
                if (value.equalsIgnoreCase(strings[i2])) {
                    int monthsAgo = now.get(2) - i2;
                    if (monthsAgo <= 0) {
                        monthsAgo += 12;
                    }
                    now.add(2, -monthsAgo);
                    return now;
                }
                ++i2;
            }
            if (value.equals("week")) {
                now.add(5, -7);
                return now;
            }
        } else {
            if (value.equals("yesterday")) {
                now.add(5, -1);
                return now;
            }
            if (value.equals("tomorrow")) {
                now.add(5, 1);
                return now;
            }
        }
        int i = 0;
        while (i < dateFormats.length) {
            try {
                Date datetime = dateFormats[i].parse(original);
                Calendar cal = Calendar.getInstance();
                cal.setTime(datetime);
                return cal;
            }
            catch (ParseException pe) {
                ++i;
            }
        }
        throw new RuntimeException("Unable to parse '" + original + "'.");
    }

    public static Iterator getCalendarIterator(Calendar focus, int rangeStyle) {
        Calendar start = null;
        Calendar end = null;
        int startCutoff = 1;
        int endCutoff = 7;
        switch (rangeStyle) {
            case 5: 
            case 6: {
                start = CalendarUtils.trunc(focus, 2);
                end = (Calendar)start.clone();
                end.add(2, 1);
                end.add(5, -1);
                if (rangeStyle != 6) break;
                startCutoff = 2;
                endCutoff = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                start = CalendarUtils.trunc(focus, 5);
                end = CalendarUtils.trunc(focus, 5);
                switch (rangeStyle) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        startCutoff = 2;
                        endCutoff = 1;
                        break;
                    }
                    case 3: {
                        startCutoff = focus.get(7);
                        endCutoff = startCutoff - 1;
                        break;
                    }
                    case 4: {
                        startCutoff = focus.get(7) - 3;
                        endCutoff = focus.get(7) + 3;
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("The range style " + rangeStyle + " is not valid.");
            }
        }
        if (startCutoff < 1) {
            startCutoff += 7;
        }
        if (endCutoff > 7) {
            endCutoff -= 7;
        }
        while (start.get(7) != startCutoff) {
            start.add(5, -1);
        }
        while (end.get(7) != endCutoff) {
            end.add(5, 1);
        }
        final Calendar startFinal = start;
        final Calendar endFinal = end;
        Iterator it = new Iterator(){
            Calendar spot = startFinal;
            {
                this.spot.add(5, -1);
            }

            public boolean hasNext() {
                return this.spot.before(endFinal);
            }

            public Object next() {
                if (this.spot.equals(endFinal)) {
                    throw new NoSuchElementException();
                }
                this.spot.add(5, 1);
                return this.spot.clone();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return it;
    }

    public static Iterator getCalendarIterator(Date focus, int rangeStyle) {
        GregorianCalendar gval = new GregorianCalendar();
        gval.setTime(focus);
        return CalendarUtils.getCalendarIterator(gval, rangeStyle);
    }

    public static Iterator getCalendarIterator(Object focus, int rangeStyle) {
        if (focus instanceof Date) {
            return CalendarUtils.getCalendarIterator((Date)focus, rangeStyle);
        }
        if (focus instanceof Calendar) {
            return CalendarUtils.getCalendarIterator((Calendar)focus, rangeStyle);
        }
        throw new ClassCastException("Could not iterate based on " + focus);
    }
}

