/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.AbstractList;

public abstract class AbstractShortList
extends AbstractList {
    public abstract int size();

    public abstract short getShort(int var1);

    public boolean containsShort(short value) {
        return this.indexOfShort(value) >= 0;
    }

    public int indexOfShort(short value) {
        int i = 0;
        while (i < this.size()) {
            if (this.getShort(i) == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOfShort(short value) {
        int i = this.size() - 1;
        while (i >= 0) {
            if (this.getShort(i) == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public Object get(int index) {
        return new Short(this.getShort(index));
    }

    public boolean contains(Object value) {
        return this.containsShort((Short)value);
    }

    public boolean isEmpty() {
        return 0 == this.size();
    }

    public int indexOf(Object value) {
        return this.indexOfShort((Short)value);
    }

    public int lastIndexOf(Object value) {
        return this.lastIndexOfShort((Short)value);
    }

    public abstract short setShort(int var1, short var2);

    public abstract void addShort(int var1, short var2);

    public abstract short removeShortAt(int var1);

    public abstract void clear();

    public boolean addShort(short value) {
        this.addShort(this.size(), value);
        return true;
    }

    public boolean removeShort(short value) {
        int i = this.indexOfShort(value);
        if (i < 0) {
            return false;
        }
        this.removeShortAt(i);
        return true;
    }

    public Object set(int index, Object value) {
        return new Short(this.setShort(index, (Short)value));
    }

    public boolean add(Object value) {
        return this.addShort((Short)value);
    }

    public void add(int index, Object value) {
        this.addShort(index, (Short)value);
    }

    public Object remove(int index) {
        return new Short(this.removeShortAt(index));
    }

    public boolean remove(Object value) {
        return this.removeShort((Short)value);
    }
}

