/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.resources.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.resources.ResourcesException;
import org.apache.commons.resources.ResourcesKeyException;
import org.apache.commons.resources.impl.ResourcesBase;

public abstract class CollectionResourcesBase
extends ResourcesBase {
    protected String base = null;
    protected Locale defaultLocale = Locale.getDefault();
    private Map lists = new HashMap();
    private Map maps = new HashMap();

    public CollectionResourcesBase(String name, String base) {
        super(name);
        this.base = base;
    }

    public Object getObject(String key, Locale locale, TimeZone timeZone) {
        if (locale == null) {
            locale = this.defaultLocale;
        }
        Object value = null;
        List list = this.getLocaleList(locale);
        int n = list.size();
        int i = 0;
        while (i < n) {
            Map map = this.getLocaleMap((Locale)list.get(i));
            if (map.containsKey(key)) {
                return map.get(key);
            }
            ++i;
        }
        if (this.isReturnNull()) {
            return null;
        }
        throw new ResourcesKeyException(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws ResourcesException {
        Map map = this.lists;
        synchronized (map) {
            this.lists.clear();
        }
        Map map2 = this.maps;
        synchronized (map2) {
            this.maps.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getLocaleList(Locale locale) {
        Map map = this.lists;
        synchronized (map) {
            ArrayList<Locale> list = (ArrayList<Locale>)this.lists.get(locale);
            if (list != null) {
                return list;
            }
            list = new ArrayList<Locale>();
            String language = locale.getLanguage();
            int languageLength = language.length();
            String country = locale.getCountry();
            int countryLength = country.length();
            String variant = locale.getVariant();
            int variantLength = variant.length();
            list.add(locale);
            if (variantLength > 0) {
                list.add(new Locale(language, country, ""));
            }
            if (countryLength > 0 && languageLength > 0) {
                list.add(new Locale(language, "", ""));
            }
            if (languageLength > 0 || countryLength > 0) {
                list.add(new Locale("", "", ""));
            }
            this.lists.put(locale, list);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getLocaleMap(Locale locale) {
        Map map = this.maps;
        synchronized (map) {
            Map map2 = (Map)this.maps.get(locale);
            if (map2 != null) {
                return map2;
            }
            map2 = this.getLocaleMap(this.base, locale);
            this.maps.put(locale, map2);
            return map2;
        }
    }

    protected abstract Map getLocaleMap(String var1, Locale var2);

    protected String getLocaleSuffix(Locale locale) {
        String variant;
        String country;
        String language;
        if (locale == null) {
            locale = this.defaultLocale;
        }
        if ((language = locale.getLanguage()) == null) {
            language = "";
        }
        if ((country = locale.getCountry()) == null) {
            country = "";
        }
        if (language.length() < 1 && country.length() < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (language.length() > 0) {
            sb.append('_');
            sb.append(language.toLowerCase());
        }
        if (country.length() > 0) {
            sb.append('_');
            sb.append(country.toUpperCase());
        }
        if ((variant = locale.getVariant()) != null && variant.length() > 0) {
            sb.append('_');
            sb.append(variant);
        }
        return sb.toString();
    }
}

