/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ResponseUtils;

public class HtmlTag
extends TagSupport {
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.html.LocalStrings");
    protected boolean locale = false;
    protected boolean xhtml = false;

    public boolean getLocale() {
        return this.locale;
    }

    public void setLocale(boolean locale) {
        this.locale = locale;
    }

    public boolean getXhtml() {
        return this.xhtml;
    }

    public void setXhtml(boolean xhtml) {
        this.xhtml = xhtml;
    }

    public int doStartTag() throws JspException {
        boolean validLanguage;
        StringBuffer sb = new StringBuffer("<html");
        Locale currentLocale = this.getCurrentLocale();
        String lang = currentLocale.getLanguage();
        boolean bl = validLanguage = lang != null && lang.length() > 0;
        if (this.xhtml) {
            this.pageContext.setAttribute("org.apache.struts.globals.XHTML", (Object)"true", 1);
            sb.append(" xmlns=\"http://www.w3.org/1999/xhtml\"");
        }
        if ((this.locale || this.xhtml) && validLanguage) {
            sb.append(" lang=\"");
            sb.append(lang);
            sb.append("\"");
        }
        if (this.xhtml && validLanguage) {
            sb.append(" xml:lang=\"");
            sb.append(lang);
            sb.append("\"");
        }
        sb.append(">");
        ResponseUtils.write(this.pageContext, sb.toString());
        return 1;
    }

    public int doEndTag() throws JspException {
        ResponseUtils.write(this.pageContext, "</html>");
        return 6;
    }

    public void release() {
        this.locale = false;
        this.xhtml = false;
    }

    protected Locale currentLocale() {
        Locale current;
        HttpSession session = this.pageContext.getSession();
        if (this.locale && session == null) {
            session = ((HttpServletRequest)this.pageContext.getRequest()).getSession();
        }
        if ((current = (Locale)session.getAttribute("org.apache.struts.action.LOCALE")) != null) {
            return current;
        }
        if (!this.locale) {
            return null;
        }
        current = this.pageContext.getRequest().getLocale();
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)current);
        return current;
    }

    protected Locale getCurrentLocale() {
        Locale current;
        HttpSession session = this.pageContext.getSession();
        if (this.locale && session == null) {
            session = ((HttpServletRequest)this.pageContext.getRequest()).getSession();
        }
        if ((current = (Locale)session.getAttribute("org.apache.struts.action.LOCALE")) != null) {
            return current;
        }
        current = this.pageContext.getRequest().getLocale();
        if (this.locale) {
            session.setAttribute("org.apache.struts.action.LOCALE", (Object)current);
        }
        return current;
    }
}

