/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.Controller;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;
import org.apache.struts.tiles.TilesUtil;
import org.apache.struts.tiles.TilesUtilStrutsImpl;

public class TilesRequestProcessor
extends RequestProcessor {
    protected DefinitionsFactory definitionsFactory;
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$struts$tiles$TilesRequestProcessor == null ? (class$org$apache$struts$tiles$TilesRequestProcessor = TilesRequestProcessor.class$("org.apache.struts.tiles.TilesRequestProcessor")) : class$org$apache$struts$tiles$TilesRequestProcessor));
    static /* synthetic */ Class class$org$apache$struts$tiles$TilesRequestProcessor;

    public void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
        super.init(servlet, moduleConfig);
        this.initDefinitionsMapping();
    }

    protected void initDefinitionsMapping() throws ServletException {
        this.definitionsFactory = ((TilesUtilStrutsImpl)TilesUtil.getTilesUtil()).getDefinitionsFactory(this.getServletContext(), this.moduleConfig);
        if (this.definitionsFactory == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Definition Factory not found for module '" + this.moduleConfig.getPrefix() + "'. " + "Have you declared the appropriate plugin in struts-config.xml ?"));
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Tiles definition factory found for request processor '" + this.moduleConfig.getPrefix() + "'."));
        }
    }

    protected boolean processTilesDefinition(String definitionName, boolean contextRelative, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean doInclude = false;
        Controller controller = null;
        String uri = null;
        ComponentContext tileContext = null;
        try {
            ComponentDefinition definition;
            tileContext = ComponentContext.getContext((ServletRequest)request);
            boolean bl = doInclude = tileContext != null;
            if (this.definitionsFactory != null && (definition = this.definitionsFactory.getDefinition(definitionName, (ServletRequest)request, this.getServletContext())) != null) {
                uri = definition.getPath();
                controller = definition.getOrCreateController();
                if (tileContext == null) {
                    tileContext = new ComponentContext(definition.getAttributes());
                    ComponentContext.setContext(tileContext, (ServletRequest)request);
                } else {
                    tileContext.addMissing(definition.getAttributes());
                }
            }
            if ((definition = DefinitionsUtil.getActionDefinition((ServletRequest)request)) != null) {
                if (definition.getPath() != null) {
                    uri = definition.getPath();
                }
                if (definition.getOrCreateController() != null) {
                    controller = definition.getOrCreateController();
                }
                if (tileContext == null) {
                    tileContext = new ComponentContext(definition.getAttributes());
                    ComponentContext.setContext(tileContext, (ServletRequest)request);
                } else {
                    tileContext.addMissing(definition.getAttributes());
                }
            }
        }
        catch (InstantiationException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create associated controller", (Throwable)ex);
            }
            throw new ServletException("Can't create associated controller", (Throwable)ex);
        }
        catch (DefinitionsFactoryException ex) {
            throw new ServletException((Throwable)ex);
        }
        if (uri == null) {
            return false;
        }
        if (controller != null) {
            controller.perform(tileContext, request, response, this.getServletContext());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("uri=" + uri + " doInclude=" + doInclude));
        }
        if (doInclude) {
            this.doInclude(uri, request, response);
        } else {
            this.doForward(uri, request, response);
        }
        return true;
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted()) {
            this.doInclude(uri, request, response);
        } else {
            super.doForward(uri, request, response);
        }
    }

    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        if (forward == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("processForwardConfig(" + forward.getPath() + ", " + forward.getContextRelative() + ")"));
        }
        if (this.processTilesDefinition(forward.getPath(), forward.getContextRelative(), request, response)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  '" + forward.getPath() + "' - processed as definition"));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("  '" + forward.getPath() + "' - processed as uri"));
        }
        super.processForwardConfig(request, response, forward);
    }

    protected void internalModuleRelativeForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.processTilesDefinition(uri, false, request, response)) {
            return;
        }
        super.internalModuleRelativeForward(uri, request, response);
    }

    protected void internalModuleRelativeInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.processTilesDefinition(uri, false, request, response)) {
            return;
        }
        super.internalModuleRelativeInclude(uri, request, response);
    }

    public DefinitionsFactory getDefinitionsFactory() {
        return this.definitionsFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

