/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.jetty.control;

import netjfwatcher.jetty.control.JettyControl;
import netjfwatcher.jetty.control.JettyException;
import netjfwatcher.jetty.control.JettyServerThread;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorSite;
import org.mortbay.jetty.Server;

public class JettyServerCheckTimerProcessor
implements Runnable {
    public static final int TIMER = 1000;
    public static final int TIMER_STOP = -1;
    private static Color BLUE_COLOR = new Color(null, 0, 0, 255);
    private Text jettyServerStatusText;
    private Text jettyServerRunningText;
    private Text jettyServerStartingText;
    private Text jettyServerStartedText;
    private Text jettyServerFailedText;
    private Text jettyServerStoppingText;
    private Button startButton;
    private Button stopButton;
    private Button browserButton;
    private Display display;
    private IEditorSite editorSite;

    public void run() {
        if (this.editorSite.getPage().isPartVisible(this.editorSite.getPart())) {
            Server server = JettyControl.getInstance().getJettyServer();
            if (server != null) {
                this.jettyServerRunningText.setText(Boolean.toString(server.isRunning()));
                this.jettyServerStartingText.setText(Boolean.toString(server.isStarting()));
                this.jettyServerStartedText.setText(Boolean.toString(server.isStarted()));
                this.jettyServerFailedText.setText(Boolean.toString(server.isFailed()));
                this.jettyServerStoppingText.setText(Boolean.toString(server.isStopping()));
                if (server.isRunning() && !server.isStarting() && server.isStarted()) {
                    this.jettyServerStatusText.setText("ready");
                    this.jettyServerStatusText.setForeground(BLUE_COLOR);
                    this.startButton.setEnabled(false);
                    this.stopButton.setEnabled(true);
                    this.browserButton.setEnabled(true);
                }
                if (!JettyServerThread.getInstance().checkThread() && !JettyServerThread.getInstance().getMessage().equals("")) {
                    MessageDialog.openError((Shell)this.editorSite.getShell(), (String)"Abort Jetty start", (String)JettyServerThread.getInstance().getMessage());
                    try {
                        JettyServerThread.getInstance().stopJettyServerThread();
                    }
                    catch (JettyException e) {
                        e.printStackTrace();
                    }
                    this.startButton.setEnabled(true);
                    this.stopButton.setEnabled(true);
                    this.browserButton.setEnabled(false);
                    this.display.timerExec(-1, (Runnable)this);
                    return;
                }
            } else {
                this.jettyServerRunningText.setText("");
                this.jettyServerStartingText.setText("");
                this.jettyServerStartedText.setText("");
                this.jettyServerFailedText.setText("");
                this.jettyServerStoppingText.setText("");
            }
        }
        this.display.timerExec(1000, (Runnable)this);
    }

    public void setEditorSite(IEditorSite editorSite) {
        this.editorSite = editorSite;
    }

    public void setText(Text jettyServerStatusText, Text jettyServerRunningText, Text jettyServerStartingText, Text jettyServerStartedText, Text jettyServerFailedText, Text jettyServerStoppingText) {
        this.jettyServerStatusText = jettyServerStatusText;
        this.jettyServerRunningText = jettyServerRunningText;
        this.jettyServerStartingText = jettyServerStartingText;
        this.jettyServerStartedText = jettyServerStartedText;
        this.jettyServerFailedText = jettyServerFailedText;
        this.jettyServerStoppingText = jettyServerStoppingText;
    }

    public void setButton(Button startButton, Button stopButton, Button browserButton) {
        this.startButton = startButton;
        this.stopButton = stopButton;
        this.browserButton = browserButton;
    }

    public static JettyServerCheckTimerProcessor getInstance() {
        return SingletonResource.RESOURCE;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    private static class SingletonResource {
        static final JettyServerCheckTimerProcessor RESOURCE = new JettyServerCheckTimerProcessor();

        private SingletonResource() {
        }
    }
}

