/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.bio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.bio.SocketEndPoint;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.Request;
import org.mortbay.log.Log;

public class SocketConnector
extends AbstractConnector {
    protected ServerSocket _serverSocket;

    public Object getConnection() {
        return this._serverSocket;
    }

    public void open() throws IOException {
        this._serverSocket = this.newServerSocket(this.getHost(), this.getPort(), this.getAcceptQueueSize());
    }

    protected ServerSocket newServerSocket(String host, int port, int backlog) throws IOException {
        ServerSocket ss = host == null ? new ServerSocket(port, backlog) : new ServerSocket(port, backlog, InetAddress.getByName(host));
        return ss;
    }

    public void close() throws IOException {
        if (this._serverSocket != null) {
            this._serverSocket.close();
        }
        this._serverSocket = null;
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        Socket socket = this._serverSocket.accept();
        this.configure(socket);
        Connection connection = new Connection(socket);
        connection.dispatch();
    }

    protected Buffer newBuffer(int size) {
        return new ByteArrayBuffer(size);
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        Connection connection = (Connection)endpoint;
        if (connection._sotimeout != this._maxIdleTime) {
            connection._sotimeout = this._maxIdleTime;
            ((Socket)endpoint.getConnection()).setSoTimeout(this._maxIdleTime);
        }
        super.customize(endpoint, request);
    }

    public int getLocalPort() {
        if (this._serverSocket == null || this._serverSocket.isClosed()) {
            return -1;
        }
        return this._serverSocket.getLocalPort();
    }

    protected class Connection
    extends SocketEndPoint
    implements Runnable {
        boolean _dispatched;
        HttpConnection _connection;
        int _sotimeout;
        Socket _socket;

        public Connection(Socket socket) throws IOException {
            super(socket);
            this._dispatched = false;
            this._connection = new HttpConnection(SocketConnector.this, this, SocketConnector.this.getServer());
            this._sotimeout = socket.getSoTimeout();
            this._socket = socket;
        }

        public void dispatch() throws InterruptedException, IOException {
            if (!SocketConnector.this.getThreadPool().dispatch(this)) {
                Log.warn((String)"dispatch failed for {}", (Object)this._connection);
                this.close();
            }
        }

        public int fill(Buffer buffer) throws IOException {
            int l = super.fill(buffer);
            if (l < 0) {
                this.close();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                SocketConnector.this.connectionOpened(this._connection);
                while (SocketConnector.this.isStarted() && !this.isClosed()) {
                    if (this._connection.isIdle() && SocketConnector.this.getServer().getThreadPool().isLowOnThreads() && this._sotimeout != SocketConnector.this.getLowResourceMaxIdleTime()) {
                        this._sotimeout = SocketConnector.this.getLowResourceMaxIdleTime();
                        this._socket.setSoTimeout(this._sotimeout);
                    }
                    this._connection.handle();
                }
            }
            catch (EofException e) {
                Log.debug((String)"EOF", (Object)e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore((Throwable)e2);
                }
            }
            catch (HttpException e) {
                Log.debug((String)"BAD", (Object)e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore((Throwable)e2);
                }
            }
            catch (Throwable e) {
                Log.warn((String)"handle failed", (Throwable)e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore((Throwable)e2);
                }
            }
            finally {
                SocketConnector.this.connectionClosed(this._connection);
            }
        }
    }
}

