/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandlerContainer;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiException;

public class HandlerCollection
extends AbstractHandlerContainer {
    private Handler[] _handlers;

    public Handler[] getHandlers() {
        return this._handlers;
    }

    public void setHandlers(Handler[] handlers) {
        int i;
        Object[] old_handlers;
        Object[] objectArray = old_handlers = this._handlers == null ? null : (Handler[])this._handlers.clone();
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, old_handlers, handlers, "handler");
        }
        Server server = this.getServer();
        MultiException mex = new MultiException();
        for (i = 0; handlers != null && i < handlers.length; ++i) {
            if (handlers[i].getServer() != server) {
                handlers[i].setServer(server);
            }
            try {
                if (!this.isStarted()) continue;
                handlers[i].start();
                continue;
            }
            catch (Throwable e) {
                mex.add(e);
            }
        }
        this._handlers = handlers;
        for (i = 0; old_handlers != null && i < old_handlers.length; ++i) {
            if (old_handlers[i] == null) continue;
            try {
                if (!old_handlers[i].isStarted()) continue;
                old_handlers[i].stop();
                continue;
            }
            catch (Throwable e) {
                mex.add(e);
            }
        }
        mex.ifExceptionThrowRuntime();
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (this._handlers != null && this.isStarted()) {
            MultiException mex = null;
            for (int i = 0; i < this._handlers.length; ++i) {
                try {
                    this._handlers[i].handle(target, request, response, dispatch);
                    continue;
                }
                catch (EofException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (mex == null) {
                        mex = new MultiException();
                    }
                    mex.add((Throwable)e);
                }
            }
            if (mex != null) {
                throw new ServletException(mex);
            }
        }
    }

    protected void doStart() throws Exception {
        MultiException mex = new MultiException();
        if (this._handlers != null) {
            for (int i = 0; i < this._handlers.length; ++i) {
                try {
                    this._handlers[i].start();
                    continue;
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        super.doStart();
        mex.ifExceptionThrow();
    }

    protected void doStop() throws Exception {
        MultiException mex = new MultiException();
        try {
            super.doStop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (this._handlers != null) {
            int i = this._handlers.length;
            while (i-- > 0) {
                try {
                    this._handlers[i].stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    public void setServer(Server server) {
        Server old_server = this.getServer();
        super.setServer(server);
        Handler[] h = this.getHandlers();
        for (int i = 0; h != null && i < h.length; ++i) {
            h[i].setServer(server);
        }
        if (server != null && server != old_server) {
            server.getContainer().update((Object)this, null, this._handlers, "handler");
        }
    }

    public void addHandler(Handler handler) {
        this.setHandlers((Handler[])LazyList.addToArray((Object[])this.getHandlers(), (Object)handler, (Class)Handler.class));
    }

    public void removeHandler(Handler handler) {
        Object[] handlers = this.getHandlers();
        if (handlers != null && handlers.length > 0) {
            this.setHandlers((Handler[])LazyList.removeFromArray((Object[])handlers, (Object)handler));
        }
    }

    protected Object expandChildren(Object list, Class byClass) {
        Handler[] handlers = this.getHandlers();
        for (int i = 0; handlers != null && i < handlers.length; ++i) {
            list = this.expandHandler(handlers[i], list, byClass);
        }
        return list;
    }
}

