/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;

public class HttpChannelEndPoint
extends SelectChannelConnector.SelectChannelEndPoint
implements Runnable {
    public SelectChannelConnector.SelectSet _selectSet;
    private boolean _dispatched = false;
    protected boolean _writable = true;
    protected SelectionKey _key;
    private int _interestOps;
    private int _readBlocked;
    private int _writeBlocked;
    private IdleTask _timeoutTask = new IdleTask();

    public HttpChannelEndPoint(SelectChannelConnector connector, SocketChannel channel, SelectChannelConnector.SelectSet selectSet, SelectionKey key) {
        super(connector, channel);
        this._selectSet = selectSet;
        this._connector = connector;
        this._connection = new HttpConnection(connector, this, connector.getServer());
        this.open(this._connection);
        this._key = key;
        this._key.attach(this);
        this._selectSet.scheduleIdle(this._timeoutTask, this._connection.isIdle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch(boolean assumeShortDispatch) throws IOException {
        this._selectSet.scheduleIdle(this._timeoutTask, this._connection.isIdle());
        HttpChannelEndPoint httpChannelEndPoint = this;
        synchronized (httpChannelEndPoint) {
            if (this._readBlocked > 0 || this._writeBlocked > 0) {
                this.notifyAll();
                this._key.interestOps(0);
                return false;
            }
            if (!assumeShortDispatch) {
                this._key.interestOps(0);
            }
            if (this._dispatched) {
                this._key.interestOps(0);
                return false;
            }
            if (this._key == null) {
                return false;
            }
            if ((this._key.readyOps() & 4) == 4 && (this._key.interestOps() & 4) == 4) {
                this._interestOps = this._key.interestOps() & 0xFFFFFFFB;
                this._key.interestOps(this._interestOps);
            }
            this._dispatched = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undispatch() {
        HttpChannelEndPoint httpChannelEndPoint = this;
        synchronized (httpChannelEndPoint) {
            try {
                this._dispatched = false;
                if (this.getChannel().isOpen()) {
                    this.updateKey();
                    if (this._connection.isIdle()) {
                        this._selectSet.scheduleIdle(this._timeoutTask, true);
                    }
                }
            }
            catch (Exception e) {
                Log.ignore((Throwable)e);
                this._interestOps = -1;
                this._selectSet.addChange(this);
            }
        }
    }

    public int fill(Buffer buffer) throws IOException {
        int l = super.fill(buffer);
        if (l < 0) {
            this.getChannel().close();
        }
        return l;
    }

    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        int l = super.flush(header, buffer, trailer);
        this._writable = l > 0;
        return l;
    }

    public int flush(Buffer buffer) throws IOException {
        int l = super.flush(buffer);
        this._writable = l > 0;
        return l;
    }

    public boolean isOpen() {
        return super.isOpen() && this._key.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockReadable(long timeoutMs) {
        HttpChannelEndPoint httpChannelEndPoint = this;
        synchronized (httpChannelEndPoint) {
            if (this.isOpen()) {
                try {
                    ++this._readBlocked;
                    this.updateKey();
                    this.wait(timeoutMs);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    --this._readBlocked;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockWritable(long timeoutMs) {
        HttpChannelEndPoint httpChannelEndPoint = this;
        synchronized (httpChannelEndPoint) {
            if (this.isOpen()) {
                try {
                    ++this._writeBlocked;
                    this.updateKey();
                    this.wait(timeoutMs);
                }
                catch (InterruptedException e) {
                    Log.ignore((Throwable)e);
                }
                finally {
                    --this._writeBlocked;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKey() {
        HttpChannelEndPoint httpChannelEndPoint = this;
        synchronized (httpChannelEndPoint) {
            int ops = this._key == null ? 0 : this._key.interestOps();
            this._interestOps = ops | (!this._dispatched || this._readBlocked > 0 ? 1 : 0) | (!this._writable || this._writeBlocked > 0 ? 4 : 0);
            this._writable = true;
            if (this._interestOps != ops) {
                this._selectSet.addChange(this);
                this._selectSet.wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncKey() {
        HttpChannelEndPoint httpChannelEndPoint = this;
        synchronized (httpChannelEndPoint) {
            if (this._key != null && this._key.isValid()) {
                if (this._interestOps >= 0) {
                    this._key.interestOps(this._interestOps);
                } else {
                    this._key.cancel();
                    this._key = null;
                }
            } else {
                this._key = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this._connection.handle();
        }
        catch (ClosedChannelException e) {
            Log.ignore((Throwable)e);
        }
        catch (EofException e) {
            Log.debug((String)"EOF", (Object)e);
            try {
                this.close();
            }
            catch (IOException e2) {
                Log.ignore((Throwable)e2);
            }
        }
        catch (HttpException e) {
            Log.debug((String)"BAD", (Object)e);
            try {
                this.close();
            }
            catch (IOException e2) {
                Log.ignore((Throwable)e2);
            }
        }
        catch (Throwable e) {
            Log.warn((String)"handle failed", (Throwable)e);
            try {
                this.close();
            }
            catch (IOException e2) {
                Log.ignore((Throwable)e2);
            }
        }
        finally {
            SelectChannelConnector.RetryContinuation continuation = (SelectChannelConnector.RetryContinuation)this._connection.getRequest().getContinuation();
            if (continuation != null) {
                Log.debug((String)"continuation {}", (Object)continuation);
                if (!continuation.schedule()) {
                    this.undispatch();
                }
            } else {
                this.undispatch();
            }
        }
    }

    public void close() throws IOException {
        if (this._key != null) {
            this._key.cancel();
        }
        this._key = null;
        this._selectSet.cancelIdle(this._timeoutTask);
        SelectChannelConnector.RetryContinuation continuation = (SelectChannelConnector.RetryContinuation)this._connection.getRequest().getContinuation();
        if (continuation != null && continuation.isPending()) {
            continuation.reset();
        }
        try {
            super.close();
        }
        catch (IOException e) {
            throw e instanceof EofException ? e : new EofException(e);
        }
    }

    public String toString() {
        return "HEP@" + this.hashCode() + "[d=" + this._dispatched + ",io=" + this._interestOps + ",w=" + this._writable + ",b=" + this._readBlocked + "|" + this._writeBlocked + "]";
    }

    public IdleTask getTimeoutTask() {
        return this._timeoutTask;
    }

    public SelectChannelConnector.SelectSet getSelectSet() {
        return this._selectSet;
    }

    public class IdleTask
    extends Timeout.Task {
        volatile boolean _short = false;

        public void expire() {
            try {
                HttpChannelEndPoint.this.close();
            }
            catch (IOException e) {
                Log.ignore((Throwable)e);
            }
        }

        public String toString() {
            return "TimeoutTask:" + HttpChannelEndPoint.this.toString();
        }

        public boolean isShort() {
            return this._short;
        }

        public void setShort(boolean _short) {
            this._short = _short;
        }
    }
}

