/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.PermissionCollection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.mortbay.io.IO;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.log.Log;
import org.mortbay.resource.JarResource;
import org.mortbay.resource.Resource;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class WebAppContext
extends Context {
    public static final String WEB_DEFAULTS_XML = "org/mortbay/jetty/webapp/webdefault.xml";
    public static final String ERROR_PAGE = "org.mortbay.jetty.error_page";
    private static String[] __dftConfigurationClasses = new String[]{"org.mortbay.jetty.webapp.WebInfConfiguration", "org.mortbay.jetty.webapp.WebXmlConfiguration", "org.mortbay.jetty.webapp.JettyWebXmlConfiguration", "org.mortbay.jetty.webapp.TagLibConfiguration"};
    private String[] _configurationClasses = __dftConfigurationClasses;
    private Configuration[] _configurations;
    private String _defaultsDescriptor = "org/mortbay/jetty/webapp/webdefault.xml";
    private boolean _distributable = false;
    private boolean _extractWAR = true;
    private boolean _parentLoaderPriority = Boolean.getBoolean("org.mortbay.jetty.webapp.parentLoaderPriority");
    private PermissionCollection _permissions;
    private String[] _systemClasses = new String[]{"java.", "javax.servlet.", "javax.xml.", "org.mortbay.", "org.xml.", "org.w3c."};
    private String[] _serverClasses = new String[]{"org.mortbay.", "-org.mortbay.naming.", "-org.mortbay.util.", "org.slf4j."};
    private File _tmpDir;
    private boolean _isExistingTmpDir;
    private String _war;
    private transient Map _resourceAliases;
    private transient boolean _ownClassLoader = false;
    static /* synthetic */ Class class$org$mortbay$jetty$webapp$WebAppContext;
    static /* synthetic */ Class class$javax$servlet$ServletException;

    public static WebAppContext getCurrentWebAppContext() {
        ContextHandler handler;
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context != null && (handler = context.getContextHandler()) instanceof WebAppContext) {
            return (WebAppContext)handler;
        }
        return null;
    }

    public static void addWebApplications(Server server, String webapps, String defaults, boolean extract, boolean java2CompliantClassLoader) throws IOException {
        WebAppContext.addWebApplications(server, webapps, defaults, __dftConfigurationClasses, extract, java2CompliantClassLoader);
    }

    public static void addWebApplications(Server server, String webapps, String defaults, String[] configurations, boolean extract, boolean java2CompliantClassLoader) throws IOException {
        HandlerCollection contexts = (HandlerCollection)server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (contexts == null) {
            contexts = (HandlerCollection)server.getChildHandlerByClass(HandlerCollection.class);
        }
        WebAppContext.addWebApplications(contexts, webapps, defaults, configurations, extract, java2CompliantClassLoader);
    }

    public static void addWebApplications(HandlerContainer contexts, String webapps, String defaults, boolean extract, boolean java2CompliantClassLoader) throws IOException {
        WebAppContext.addWebApplications(contexts, webapps, defaults, __dftConfigurationClasses, extract, java2CompliantClassLoader);
    }

    public static void addWebApplications(HandlerContainer contexts, String webapps, String defaults, String[] configurations, boolean extract, boolean java2CompliantClassLoader) throws IOException {
        Resource r;
        if (contexts == null) {
            throw new IllegalArgumentException("No HandlerContainer");
        }
        if (configurations == null) {
            configurations = __dftConfigurationClasses;
        }
        if (!(r = Resource.newResource(webapps)).exists()) {
            throw new IllegalArgumentException("No such webapps resource " + r);
        }
        if (!r.isDirectory()) {
            throw new IllegalArgumentException("Not directory webapps resource " + r);
        }
        String[] files = r.list();
        block0: for (int f = 0; files != null && f < files.length; ++f) {
            Resource unpacked;
            String context = files[f];
            if (context.equalsIgnoreCase("CVS/") || context.equalsIgnoreCase("CVS") || context.startsWith(".")) continue;
            Resource app = r.addPath(r.encode(context));
            if (!context.toLowerCase().endsWith(".war") && !context.toLowerCase().endsWith(".jar") ? !app.isDirectory() : (unpacked = r.addPath(context = context.substring(0, context.length() - 4))) != null && unpacked.exists() && unpacked.isDirectory()) continue;
            context = context.equalsIgnoreCase("root") || context.equalsIgnoreCase("root/") ? "/" : "/" + context;
            if (context.endsWith("/") && context.length() > 0) {
                context = context.substring(0, context.length() - 1);
            }
            Handler[] installed = contexts.getChildHandlersByClass(class$org$mortbay$jetty$webapp$WebAppContext == null ? WebAppContext.class$("org.mortbay.jetty.webapp.WebAppContext") : class$org$mortbay$jetty$webapp$WebAppContext);
            for (int i = 0; i < installed.length; ++i) {
                WebAppContext w = (WebAppContext)installed[i];
                if (app.equals(Resource.newResource(w.getWar()))) continue block0;
            }
            WebAppContext wah = null;
            if (contexts instanceof ContextHandlerCollection && (class$org$mortbay$jetty$webapp$WebAppContext == null ? WebAppContext.class$("org.mortbay.jetty.webapp.WebAppContext") : class$org$mortbay$jetty$webapp$WebAppContext).isAssignableFrom(((ContextHandlerCollection)contexts).getContextClass())) {
                wah = (WebAppContext)((ContextHandlerCollection)contexts).addContext(context, null);
            } else {
                wah = new WebAppContext();
                wah.setContextPath(context);
                contexts.addHandler(wah);
            }
            wah.setConfigurationClasses(configurations);
            if (defaults != null) {
                wah.setDefaultsDescriptor(defaults);
            }
            wah.setExtractWAR(extract);
            wah.setWar(app.toString());
            wah.setParentLoaderPriority(java2CompliantClassLoader);
        }
    }

    public WebAppContext() {
        this(null, null, null, null);
    }

    public WebAppContext(String webApp, String contextPath) {
        super(null, contextPath, 3);
        this.setContextPath(contextPath);
        this.setWar(webApp);
        this.setErrorHandler(new WebAppErrorHandler());
    }

    public WebAppContext(HandlerContainer parent, String webApp, String contextPath) {
        super(parent, contextPath, 3);
        this.setWar(webApp);
        this.setErrorHandler(new WebAppErrorHandler());
    }

    public WebAppContext(SecurityHandler securityHandler, SessionHandler sessionHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        super(null, sessionHandler != null ? sessionHandler : new SessionHandler(), securityHandler != null ? securityHandler : new SecurityHandler(), servletHandler != null ? servletHandler : new ServletHandler(), null);
        this.setErrorHandler(errorHandler != null ? errorHandler : new WebAppErrorHandler());
    }

    public void setResourceAlias(String alias, String uri) {
        if (this._resourceAliases == null) {
            this._resourceAliases = new HashMap(5);
        }
        this._resourceAliases.put(alias, uri);
    }

    public Map getResourceAliases() {
        if (this._resourceAliases == null) {
            return null;
        }
        return this._resourceAliases;
    }

    public void setResourceAliases(Map map) {
        this._resourceAliases = map;
    }

    public String getResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.get(alias);
    }

    public String removeResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.remove(alias);
    }

    public Resource getResource(String uriInContext) throws MalformedURLException {
        IOException ioe = null;
        Resource resource = null;
        int loop = 0;
        while (uriInContext != null && loop++ < 100) {
            try {
                resource = super.getResource(uriInContext);
                if (resource != null && resource.exists()) {
                    return resource;
                }
                uriInContext = this.getResourceAlias(uriInContext);
            }
            catch (IOException e) {
                Log.ignore((Throwable)e);
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null && ioe instanceof MalformedURLException) {
            throw (MalformedURLException)ioe;
        }
        return resource;
    }

    protected void doStart() throws Exception {
        int i;
        this.loadConfigurations();
        for (i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].setWebAppContext(this);
        }
        this._ownClassLoader = false;
        if (this.getClassLoader() == null) {
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Thread Context class loader is: " + parent));
                for (ClassLoader loader = parent.getParent(); loader != null; loader = loader.getParent()) {
                    Log.debug((String)("Parent class loader is: " + loader));
                }
            }
            if (parent == null) {
                parent = this.getClass().getClassLoader();
            }
            if (parent == null) {
                parent = ClassLoader.getSystemClassLoader();
            }
            WebAppClassLoader classLoader = new WebAppClassLoader(parent, this);
            this.setClassLoader(classLoader);
            this._ownClassLoader = true;
        }
        for (i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].configureClassLoader();
        }
        this.getTempDirectory();
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        try {
            int i = this._configurations.length;
            while (i-- > 0) {
                this._configurations[i].deconfigureWebApp();
            }
            this._configurations = null;
            if (this._securityHandler.getHandler() == null) {
                this._sessionHandler.setHandler(this._securityHandler);
                this._securityHandler.setHandler(this._servletHandler);
            }
            if (!this._isExistingTmpDir && !this.isTempWorkDirectory()) {
                IO.delete(this._tmpDir);
            }
        }
        finally {
            if (this._ownClassLoader) {
                this.setClassLoader(null);
            }
        }
    }

    public String[] getConfigurationClasses() {
        return this._configurationClasses;
    }

    public Configuration[] getConfigurations() {
        return this._configurations;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public PermissionCollection getPermissions() {
        return this._permissions;
    }

    public String[] getServerClasses() {
        return this._serverClasses;
    }

    public String[] getSystemClasses() {
        return this._systemClasses;
    }

    public File getTempDirectory() {
        if (this._tmpDir != null) {
            return this._tmpDir;
        }
        Object t = this.getAttribute("javax.servlet.context.tempdir");
        if (t != null && t instanceof File) {
            this._tmpDir = (File)t;
            if (this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
                return this._tmpDir;
            }
        }
        if (t != null && t instanceof String) {
            try {
                this._tmpDir = new File((String)t);
                if (this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Converted to File " + this._tmpDir + " for " + this));
                    }
                    this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
                    return this._tmpDir;
                }
            }
            catch (Exception e) {
                Log.warn((String)"EXCEPTION ", (Throwable)e);
            }
        }
        File work = null;
        try {
            Resource web_inf;
            File w = new File(System.getProperty("jetty.home"), "work");
            if (w.exists() && w.canWrite() && w.isDirectory()) {
                work = w;
            } else if (this.getBaseResource() != null && (web_inf = this.getWebInf()) != null && web_inf.exists() && (w = new File(web_inf.getFile(), "work")).exists() && w.canWrite() && w.isDirectory()) {
                work = w;
            }
        }
        catch (Exception e) {
            Log.ignore((Throwable)e);
        }
        try {
            String temp = this.getCanonicalNameForWebAppTmpDir();
            if (work != null) {
                this._tmpDir = new File(work, temp);
            } else {
                this._tmpDir = new File(System.getProperty("java.io.tmpdir"), temp);
                if (this._tmpDir.exists()) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Delete existing temp dir " + this._tmpDir + " for " + this));
                    }
                    if (!IO.delete(this._tmpDir) && Log.isDebugEnabled()) {
                        Log.debug((String)("Failed to delete temp dir " + this._tmpDir));
                    }
                    if (this._tmpDir.exists()) {
                        String old = this._tmpDir.toString();
                        this._tmpDir = File.createTempFile(temp + "_", "");
                        if (this._tmpDir.exists()) {
                            this._tmpDir.delete();
                        }
                        Log.warn((String)("Can't reuse " + old + ", using " + this._tmpDir));
                    }
                }
            }
            if (!this._tmpDir.exists()) {
                this._tmpDir.mkdir();
            }
            if (!this.isTempWorkDirectory()) {
                this._tmpDir.deleteOnExit();
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Created temp dir " + this._tmpDir + " for " + this));
            }
        }
        catch (Exception e) {
            this._tmpDir = null;
            Log.ignore((Throwable)e);
        }
        if (this._tmpDir == null) {
            try {
                this._tmpDir = File.createTempFile("JettyContext", "");
                if (this._tmpDir.exists()) {
                    this._tmpDir.delete();
                }
                this._tmpDir.mkdir();
                this._tmpDir.deleteOnExit();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Created temp dir " + this._tmpDir + " for " + this));
                }
            }
            catch (IOException e) {
                Log.warn((String)"tmpdir", (Throwable)e);
                System.exit(1);
            }
        }
        this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
        return this._tmpDir;
    }

    public boolean isTempWorkDirectory() {
        File tmpDir = this.getTempDirectory();
        if (tmpDir == null) {
            return false;
        }
        if (tmpDir.getName().equalsIgnoreCase("work")) {
            return true;
        }
        if ((tmpDir = tmpDir.getParentFile()) == null) {
            return false;
        }
        return tmpDir.getName().equalsIgnoreCase("work");
    }

    public String getWar() {
        if (this._war == null) {
            this._war = this.getResourceBase();
        }
        return this._war;
    }

    public Resource getWebInf() throws IOException {
        this.resolveWebApp();
        Resource web_inf = super.getBaseResource().addPath("WEB-INF/");
        if (!web_inf.exists() || !web_inf.isDirectory()) {
            return null;
        }
        return web_inf;
    }

    public boolean isDistributable() {
        return this._distributable;
    }

    public boolean isExtractWAR() {
        return this._extractWAR;
    }

    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    protected void loadConfigurations() throws Exception {
        if (this._configurations != null) {
            return;
        }
        if (this._configurationClasses == null) {
            this._configurationClasses = __dftConfigurationClasses;
        }
        this._configurations = new Configuration[this._configurationClasses.length];
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i] = (Configuration)Loader.loadClass(this.getClass(), (String)this._configurationClasses[i]).newInstance();
        }
    }

    protected boolean isProtectedTarget(String target) {
        return StringUtil.startsWithIgnoreCase((String)target, (String)"/web-inf") || StringUtil.startsWithIgnoreCase((String)target, (String)"/meta-inf");
    }

    protected void resolveWebApp() throws IOException {
        Resource web_app = super.getBaseResource();
        if (web_app == null) {
            Resource jarWebApp;
            if (this._war == null || this._war.length() == 0) {
                this._war = this.getResourceBase();
            }
            if ((web_app = Resource.newResource(this._war)).getAlias() != null) {
                Log.debug((String)(web_app + " anti-aliased to " + web_app.getAlias()));
                web_app = Resource.newResource(web_app.getAlias());
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Try webapp=" + web_app + ", exists=" + web_app.exists() + ", directory=" + web_app.isDirectory()));
            }
            if (web_app.exists() && !web_app.isDirectory() && !web_app.toString().startsWith("jar:") && (jarWebApp = Resource.newResource("jar:" + web_app + "!/")).exists() && jarWebApp.isDirectory()) {
                web_app = jarWebApp;
                this._war = web_app.toString();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Try webapp=" + web_app + ", exists=" + web_app.exists() + ", directory=" + web_app.isDirectory()));
                }
            }
            if (web_app.exists() && (!web_app.isDirectory() || this._extractWAR && web_app.getFile() == null || this._extractWAR && web_app.getFile() != null && !web_app.getFile().isDirectory())) {
                File extractedWebAppDir = new File(this.getTempDirectory(), "webapp");
                if (!extractedWebAppDir.exists()) {
                    extractedWebAppDir.mkdir();
                    Log.info((String)("Extract " + this._war + " to " + extractedWebAppDir));
                    JarResource.extract(web_app, extractedWebAppDir, false);
                } else if (web_app.lastModified() > extractedWebAppDir.lastModified()) {
                    extractedWebAppDir.delete();
                    extractedWebAppDir.mkdir();
                    Log.info((String)("Extract " + this._war + " to " + extractedWebAppDir));
                    JarResource.extract(web_app, extractedWebAppDir, false);
                }
                web_app = Resource.newResource(extractedWebAppDir.getCanonicalPath());
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Try webapp=" + web_app + ", exists=" + web_app.exists() + ", directory=" + web_app.isDirectory()));
                }
            }
            if (!web_app.exists() || !web_app.isDirectory()) {
                Log.warn((String)("Web application not found " + this._war));
                throw new FileNotFoundException(this._war);
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)("webapp=" + web_app));
            }
            super.setBaseResource(web_app);
        }
    }

    public void setConfigurationClasses(String[] configurations) {
        this._configurationClasses = configurations == null ? null : (String[])configurations.clone();
    }

    public void setConfigurations(Configuration[] configurations) {
        this._configurations = configurations == null ? null : (Configuration[])configurations.clone();
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    public void setEventListeners(EventListener[] eventListeners) {
        if (this._sessionHandler != null) {
            this._sessionHandler.clearEventListeners();
        }
        super.setEventListeners(eventListeners);
        for (int i = 0; eventListeners != null && i < eventListeners.length; ++i) {
            EventListener listener = eventListeners[i];
            if (!(listener instanceof HttpSessionActivationListener) && !(listener instanceof HttpSessionAttributeListener) && !(listener instanceof HttpSessionBindingListener) && !(listener instanceof HttpSessionListener) || this._sessionHandler == null) continue;
            this._sessionHandler.addEventListener(listener);
        }
    }

    public void addEventListener(EventListener listener) {
        this.setEventListeners((EventListener[])LazyList.addToArray((Object[])this.getEventListeners(), (Object)listener, (Class)EventListener.class));
    }

    public void setExtractWAR(boolean extractWAR) {
        this._extractWAR = extractWAR;
    }

    public void setParentLoaderPriority(boolean java2compliant) {
        this._parentLoaderPriority = java2compliant;
    }

    public void setPermissions(PermissionCollection permissions) {
        this._permissions = permissions;
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        this._securityHandler = securityHandler;
    }

    public void setServerClasses(String[] serverClasses) {
        this._serverClasses = serverClasses == null ? null : (String[])serverClasses.clone();
    }

    public void setServletHandler(ServletHandler servletHandler) {
        this._servletHandler = servletHandler;
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this._sessionHandler = sessionHandler;
    }

    public void setSystemClasses(String[] systemClasses) {
        this._systemClasses = systemClasses == null ? null : (String[])systemClasses.clone();
    }

    public void setTempDirectory(File dir) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (dir != null) {
            try {
                dir = new File(dir.getCanonicalPath());
            }
            catch (IOException e) {
                Log.warn((String)"EXCEPTION ", (Throwable)e);
            }
        }
        if (dir != null && !dir.exists()) {
            dir.mkdir();
            dir.deleteOnExit();
        } else if (dir != null) {
            this._isExistingTmpDir = true;
        }
        if (!(dir == null || dir.exists() && dir.isDirectory() && dir.canWrite())) {
            throw new IllegalArgumentException("Bad temp directory: " + dir);
        }
        this._tmpDir = dir;
        this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
    }

    public void setWar(String war) {
        this._war = war;
    }

    protected void startContext() throws Exception {
        Resource work;
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].configureDefaults();
        }
        Resource web_inf = this.getWebInf();
        if (web_inf != null && (work = web_inf.addPath("work")).exists() && work.isDirectory() && work.getFile() != null && work.getFile().canWrite() && this.getAttribute("javax.servlet.context.tempdir") == null) {
            this.setAttribute("javax.servlet.context.tempdir", work.getFile());
        }
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].configureWebApp();
        }
        this._servletHandler.setInitializeAtStart(false);
        if (this._securityHandler.getConstraintMappings() == null || this._securityHandler.getConstraintMappings().length == 0) {
            this._securityHandler.setHandler(null);
            this._sessionHandler.setHandler(this._servletHandler);
        }
        super.startContext();
        if (this._servletHandler != null && this._servletHandler.isStarted()) {
            this._servletHandler.initialize();
        }
    }

    private String getCanonicalNameForWebAppTmpDir() {
        int port;
        String host;
        StringBuffer canonicalName = new StringBuffer();
        canonicalName.append("Jetty");
        Connector[] connectors = this.getServer().getConnectors();
        canonicalName.append("_");
        String string = host = connectors == null || connectors[0] == null ? "" : connectors[0].getHost();
        if (host == null) {
            host = "0.0.0.0";
        }
        canonicalName.append(host.replace('.', '_'));
        canonicalName.append("_");
        int n = port = connectors == null || connectors[0] == null ? 0 : connectors[0].getLocalPort();
        if (port < 0) {
            port = connectors[0].getPort();
        }
        canonicalName.append(port);
        canonicalName.append("_");
        String contextPath = this.getContextPath();
        contextPath = contextPath.replace('/', '_');
        contextPath = contextPath.replace('.', '_');
        contextPath = contextPath.replace('\\', '_');
        canonicalName.append(contextPath);
        canonicalName.append("_");
        String[] vhosts = this.getVirtualHosts();
        canonicalName.append(vhosts == null || vhosts[0] == null ? "" : vhosts[0]);
        return canonicalName.toString();
    }

    public class WebAppErrorHandler
    extends ErrorHandler {
        Map _errorPages;

        public Map getErrorPages() {
            return this._errorPages;
        }

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException {
            if (this._errorPages != null) {
                String old_error_page;
                Integer code;
                Class<Object> exClass;
                String error_page = null;
                if ((class$javax$servlet$ServletException == null ? (class$javax$servlet$ServletException = WebAppContext.class$("javax.servlet.ServletException")) : class$javax$servlet$ServletException).equals(exClass = (Class)request.getAttribute("javax.servlet.error.exception_type")) && (error_page = (String)this._errorPages.get(exClass.getName())) == null) {
                    Throwable th = (Throwable)request.getAttribute("javax.servlet.error.exception");
                    while (th instanceof ServletException) {
                        th = ((ServletException)th).getRootCause();
                    }
                    if (th != null) {
                        exClass = th.getClass();
                    }
                }
                while (error_page == null && exClass != null) {
                    error_page = (String)this._errorPages.get(exClass.getName());
                    exClass = exClass.getSuperclass();
                }
                if (error_page == null && (code = (Integer)request.getAttribute("javax.servlet.error.status_code")) != null) {
                    error_page = (String)this._errorPages.get(TypeUtil.toString((int)code));
                }
                if (!(error_page == null || (old_error_page = (String)request.getAttribute(WebAppContext.ERROR_PAGE)) != null && old_error_page.equals(error_page))) {
                    request.setAttribute(WebAppContext.ERROR_PAGE, (Object)error_page);
                    Dispatcher dispatcher = (Dispatcher)WebAppContext.this.getServletHandler().getServletContext().getRequestDispatcher(error_page);
                    try {
                        if (dispatcher != null) {
                            dispatcher.error((ServletRequest)request, (ServletResponse)response);
                            return;
                        }
                        Log.warn((String)("No error page " + error_page));
                    }
                    catch (ServletException e) {
                        Log.warn((String)"EXCEPTION ", (Throwable)e);
                        return;
                    }
                }
            }
            super.handle(target, request, response, dispatch);
        }

        public void setErrorPages(Map errorPages) {
            this._errorPages = errorPages;
        }
    }
}

