/*
 * Created on 2006/08/17
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.jetty.control;

import netjfwatcher.jetty.gui.JettyEditorView;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorSite;

/**
 * JettyԂĎViewɕ\^C}[NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class JettyServerCheckTimerProcessor implements Runnable {
    public static final int TIMER = 1000;
    public static final int TIMER_STOP = -1;
    private static Color BLUE_COLOR = new Color(null, 0, 0, 255);
    private Text jettyServerStatusText;
    private Text jettyServerRunningText;
    private Text jettyServerStartingText;
    private Text jettyServerStartedText;
    private Text jettyServerFailedText;
    private Text jettyServerStoppingText;
    private Button startButton;
    private Button stopButton;
    private Button browserButton;

    /* Display */
    private Display display;
    private IEditorSite editorSite;

    /**
     * TrapMf[^i[L[IɊĎAe[u\
     * NXCX^X𐶐܂B
     */
    public JettyServerCheckTimerProcessor() {
        // nothing
    }

    /**
     * TrapML[IɊĎAL[Ƀf[^ꍇɂ
     * f[^PopTrapMe[uɕ\܂B
     *
     */
    public void run() {
        if (editorSite.getPage().isPartVisible(editorSite.getPart())) {
            org.mortbay.jetty.Server server =
                JettyControl.getInstance().getJettyServer();

            if (server != null) {
                jettyServerRunningText.setText(
                    Boolean.toString(server.isRunning()));
                jettyServerStartingText.setText(
                    Boolean.toString(server.isStarting()));
                jettyServerStartedText.setText(
                    Boolean.toString(server.isStarted()));
                jettyServerFailedText.setText(
                    Boolean.toString(server.isFailed()));
                jettyServerStoppingText.setText(
                    Boolean.toString(server.isStopping()));

                if (
                    server.isRunning() && !server.isStarting()
                        && server.isStarted()) {
                    jettyServerStatusText.setText(
                        JettyEditorView.JETTY_STATUS_READY);
                    jettyServerStatusText.setForeground(BLUE_COLOR);
                    startButton.setEnabled(false);
                    stopButton.setEnabled(true);
                    browserButton.setEnabled(true);
                }

                if (!JettyServerThread.getInstance().checkThread()) {
                    if (
                        !JettyServerThread.getInstance().getMessage().equals(
                                "")) {
                        MessageDialog.openError(
                            editorSite.getShell(), "Abort Jetty start",
                            JettyServerThread.getInstance().getMessage());

                        try {
                            JettyServerThread.getInstance()
                                             .stopJettyServerThread();
                        } catch (JettyException e) {
                            e.printStackTrace();
                        }

                        startButton.setEnabled(true);
                        stopButton.setEnabled(true);
                        browserButton.setEnabled(false);
                        display.timerExec(TIMER_STOP, this);

                        return;
                    }
                }
            } else {
                jettyServerRunningText.setText("");
                jettyServerStartingText.setText("");
                jettyServerStartedText.setText("");
                jettyServerFailedText.setText("");
                jettyServerStoppingText.setText("");
            }
        }

        // ^C}[p
        display.timerExec(TIMER, this);
    }

    public void setEditorSite(IEditorSite editorSite) {
        this.editorSite = editorSite;
    }

    public void setText(
        Text jettyServerStatusText, Text jettyServerRunningText,
        Text jettyServerStartingText, Text jettyServerStartedText,
        Text jettyServerFailedText, Text jettyServerStoppingText) {
        this.jettyServerStatusText = jettyServerStatusText;
        this.jettyServerRunningText = jettyServerRunningText;
        this.jettyServerStartingText = jettyServerStartingText;
        this.jettyServerStartedText = jettyServerStartedText;
        this.jettyServerFailedText = jettyServerFailedText;
        this.jettyServerStoppingText = jettyServerStoppingText;
    }

    public void setButton(Button startButton, Button stopButton, Button browserButton) {
        this.startButton = startButton;
        this.stopButton = stopButton;
        this.browserButton = browserButton;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static JettyServerCheckTimerProcessor getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * TimersDisplayZbg܂B
     *
     * @param display TimersDisplay
     */
    public void setDisplay(Display display) {
        this.display = display;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final JettyServerCheckTimerProcessor RESOURCE =
            new JettyServerCheckTimerProcessor();
    }
}
