/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.gui.editor;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.JSch;
import java.util.logging.Logger;
import netwatcher.ssh2.gui.editor.AbstractEditorSSH;
import netwatcher.ssh2.gui.editor.EditorInputSSHNodeView;
import netwatcher.ssh2.model.JSchControl;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class EditorSSHKnownHostsFileView
extends AbstractEditorSSH {
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{800, 800};
    private JSch jsch;
    private TableViewer viewer;
    private Button removeHostKeyButton;
    private static Logger logger;

    public EditorSSHKnownHostsFileView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.jsch = JSchControl.getInstance().getJsch();
        EditorInputSSHNodeView cfr_ignored_0 = (EditorInputSSHNodeView)this.getEditorInput();
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite composite0 = new Composite((Composite)scrollComposite, 0);
        composite0.setLayout((Layout)gridLayout0);
        composite0.setLayoutData((Object)new GridData(272));
        GridLayout gridLayout = new GridLayout(1, false);
        Composite composite1 = new Composite(composite0, 0);
        composite1.setLayout((Layout)gridLayout);
        composite1.setLayoutData((Object)new GridData(256));
        this.createHostKeyManagementPage(composite1);
        scrollComposite.setContent((Control)composite0);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
    }

    private Control createHostKeyManagementPage(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        group.setLayoutData((Object)gd);
        Label label = new Label(group, 0);
        label.setText("Host Keys included in known_hosts.");
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.viewer = new TableViewer(group, 68354);
        Table table = this.viewer.getTable();
        new TableEditor(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gd = new GridData(1808);
        gd.widthHint = 600;
        gd.heightHint = 400;
        table.setLayoutData((Object)gd);
        table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                EditorSSHKnownHostsFileView.this.handleSelection();
            }
        });
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        TableColumn[] columns = table.getColumns();
        columns[0].setText("Hostname");
        columns[1].setText("Type");
        columns[2].setText("Fingerprint");
        this.viewer.setColumnProperties(new String[]{"Hostname", "Type", "Fingerprint"});
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return null;
                }
                return (Object[])inputElement;
            }
        });
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(70));
        table.setLayout((Layout)tl);
        Composite buttons = new Composite(group, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.removeHostKeyButton = new Button(buttons, 8);
        this.removeHostKeyButton.setText("Remove");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.removeHostKeyButton.setLayoutData((Object)gd);
        this.removeHostKeyButton.setEnabled(false);
        this.removeHostKeyButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                EditorSSHKnownHostsFileView.this.removeHostKey();
            }
        });
        Dialog.applyDialogFont((Control)parent);
        HostKey[] hostKey = this.jsch.getHostKeyRepository().getHostKey();
        if (hostKey != null) {
            int i = 0;
            while (i < hostKey.length) {
                this.viewer.setInput((Object)hostKey);
                ++i;
            }
        }
        this.handleSelection();
        return group;
    }

    private void handleSelection() {
        boolean empty = this.viewer.getSelection().isEmpty();
        this.removeHostKeyButton.setEnabled(!empty);
    }

    private void removeHostKey() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (HostKey hostkey : selection) {
            this.jsch.getHostKeyRepository().remove(hostkey.getHost(), hostkey.getType());
            this.viewer.remove((Object)hostkey);
        }
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            HostKey entry = (HostKey)element;
            switch (columnIndex) {
                case 0: {
                    return entry.getHost();
                }
                case 1: {
                    return entry.getType();
                }
                case 2: {
                    return entry.getFingerPrint(EditorSSHKnownHostsFileView.this.jsch);
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

