/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.gui.treeview;

import netwatcher.ssh2.gui.action.ActionBuilderEditorsPartClose;
import netwatcher.ssh2.gui.action.ActionBuilderNodeTree;
import netwatcher.ssh2.gui.treenode.ISSHUserHostTreeNode;
import netwatcher.ssh2.gui.treenode.SSHNodeTreeGroup;
import netwatcher.ssh2.gui.treeview.SSHNodeTreeListener;
import netwatcher.ssh2.gui.treeview.SSHNodeTreeViewContentProvider;
import netwatcher.ssh2.gui.treeview.SSHNodeTreeViewLabelProvider;
import netwatcher.ssh2.gui.treeview.SSHNodeTreeViewSorter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractSSHNodeTreeView
extends ViewPart {
    protected ActionBuilderNodeTree actionNodeTree;
    protected ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();
    protected TreeViewer nodeTreeViewer;

    public ActionBuilderNodeTree getActionNodeTreeBuilder() {
        return this.actionNodeTree;
    }

    public void setFocus() {
    }

    public TreeViewer getViewer() {
        return this.nodeTreeViewer;
    }

    public void createPartControl(Composite parentComposite) {
        this.nodeTreeViewer = new TreeViewer(parentComposite);
        this.nodeTreeViewer.setUseHashlookup(true);
        this.nodeTreeViewer.setContentProvider((IContentProvider)new SSHNodeTreeViewContentProvider());
        this.nodeTreeViewer.setLabelProvider((IBaseLabelProvider)new SSHNodeTreeViewLabelProvider());
        this.nodeTreeViewer.setSorter((ViewerSorter)new SSHNodeTreeViewSorter());
        this.nodeTreeViewer.setInput(this.createInitialInput());
        this.nodeTreeViewer.expandAll();
        ISSHUserHostTreeNode nodeTreeNode = (ISSHUserHostTreeNode)this.getViewer().getInput();
        SSHNodeTreeGroup nodeTreeGroupRoot = nodeTreeNode.getParent();
        if (nodeTreeNode instanceof SSHNodeTreeGroup) {
            nodeTreeGroupRoot = (SSHNodeTreeGroup)nodeTreeNode;
        }
        this.actionNodeTree = new ActionBuilderNodeTree(this, this.nodeTreeViewer, parentComposite, nodeTreeGroupRoot);
        this.setupNodeTreeViewListener();
        this.createContextMenu();
        this.setToolBarActions();
        this.initShow();
    }

    protected Object createInitialInput() {
        RootOfRootNodeTreeGroup topInputDataObject = new RootOfRootNodeTreeGroup();
        return topInputDataObject;
    }

    protected abstract void initShow();

    protected void setupNodeTreeViewListener() {
        this.nodeTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new SSHNodeTreeListener());
    }

    protected abstract void setToolBarActions();

    protected abstract void createContextMenu();

    protected static final class RootOfRootNodeTreeGroup
    extends SSHNodeTreeGroup {
        protected RootOfRootNodeTreeGroup() {
        }

        public SSHNodeTreeGroup getParent() {
            return null;
        }

        public void removeChild(ISSHUserHostTreeNode toRemove) {
        }
    }
}

