package netwatcher.ssh2.gui.editor;

import java.util.Iterator;
import java.util.logging.Logger;

import netwatcher.ssh2.model.JSchControl;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.JSch;

public class EditorSSHKnownHostsFileView extends AbstractEditorSSH {


	/* Scroll CompositeTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 800 };

	private JSch jsch;

	private TableViewer viewer;

	private Button removeHostKeyButton;

	/* Logging */
	private static Logger logger;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public EditorSSHKnownHostsFileView() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {

		jsch = JSchControl.getInstance().getJsch();

		/* ͐ݒlm[hĎ擾 */
		EditorInputSSHNodeView nodeViewEditorInput = (EditorInputSSHNodeView) getEditorInput();

		/*
		 * ViewCAEg
		 */
		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridLayout gridLayout0 = new GridLayout(1, true);
		Composite composite0 = new Composite(scrollComposite, SWT.NONE);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL
				| GridData.VERTICAL_ALIGN_FILL));

		GridLayout gridLayout = new GridLayout(1, false);
		Composite composite1 = new Composite(composite0, SWT.NULL);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		createHostKeyManagementPage(composite1);
		scrollComposite.setContent(composite0);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

	}

	class TableLabelProvider extends LabelProvider implements
			ITableLabelProvider {

		public String getColumnText(Object element, int columnIndex) {
			HostKey entry = (HostKey) element;
			switch (columnIndex) {
			case 0:
				return entry.getHost();
			case 1:
				return entry.getType();
			case 2:
				return entry.getFingerPrint(jsch);
			default:
				return null;
			}
		}

		public Image getColumnImage(Object element, int columnIndex) {
			return null;
		}
	};

	private Control createHostKeyManagementPage(Composite parent) {
		int columnSpan = 3;
		Composite group = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		layout.numColumns = 2;
		group.setLayout(layout);
		GridData gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		gd.verticalAlignment = GridData.FILL;
		group.setLayoutData(gd);

		Label label = new Label(group, SWT.NONE);
		label.setText("Host Keys included in known_hosts.");

		gd = new GridData();
		gd.horizontalSpan = 2;
		label.setLayoutData(gd);

		viewer = new TableViewer(group, SWT.MULTI | SWT.FULL_SELECTION
				| SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
		Table table = viewer.getTable();
		new TableEditor(table);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		gd = new GridData(GridData.FILL_BOTH);
		gd.widthHint = 600;
		gd.heightHint = 400;
		table.setLayoutData(gd);
		table.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				handleSelection();
			}
		});
		// Create the table columns
		new TableColumn(table, SWT.NULL);
		new TableColumn(table, SWT.NULL);
		new TableColumn(table, SWT.NULL);
		TableColumn[] columns = table.getColumns();

		columns[0].setText("Hostname");
		columns[1].setText("Type");
		columns[2].setText("Fingerprint");
		viewer.setColumnProperties(new String[] { "Hostname", "Type",
				"Fingerprint" });

		viewer.setLabelProvider(new TableLabelProvider());
		viewer.setContentProvider(new IStructuredContentProvider() {
			public void dispose() {
			}

			public void inputChanged(Viewer viewer, Object oldInput,
					Object newInput) {
			}

			public Object[] getElements(Object inputElement) {
				if (inputElement == null)
					return null;
				return (Object[]) inputElement;
			}
		});
		TableLayout tl = new TableLayout();
		tl.addColumnData(new ColumnWeightData(20));
		tl.addColumnData(new ColumnWeightData(10));
		tl.addColumnData(new ColumnWeightData(70));
		table.setLayout(tl);

		Composite buttons = new Composite(group, SWT.NULL);
		buttons.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_BEGINNING));
		layout = new GridLayout();
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		buttons.setLayout(layout);

		removeHostKeyButton = new Button(buttons, SWT.PUSH);
		removeHostKeyButton.setText("Remove");

		gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;

		removeHostKeyButton.setLayoutData(gd);
		removeHostKeyButton.setEnabled(false);
		removeHostKeyButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				removeHostKey();
			}
		});

		Dialog.applyDialogFont(parent);
		HostKey[] hostKey = jsch.getHostKeyRepository().getHostKey();
		if (hostKey != null) {
			for (int i = 0; i < hostKey.length; i++) {
				viewer.setInput(hostKey);

			}
		}
		handleSelection();

		return group;
	}

	private void handleSelection() {
		boolean empty = viewer.getSelection().isEmpty();
		removeHostKeyButton.setEnabled(!empty);
	}

	private void removeHostKey() {

		IStructuredSelection selection = (IStructuredSelection) viewer
				.getSelection();
		for (Iterator iterator = selection.iterator(); iterator.hasNext();) {
			HostKey hostkey = (HostKey) iterator.next();
			jsch.getHostKeyRepository().remove(hostkey.getHost(),
					hostkey.getType());
			viewer.remove(hostkey);
		}

	}

	/**
	 * Xe[^XC\Zbg܂B
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

}
