/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.gui.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Logger;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class EditorSSHNodeFileView extends AbstractEditorSSH {
	/** View^CgSuffix */
	public static final String TITLE_SUFFIX = " Node View";

	/** f[^\eLXg */
	public static final int DATE_TEXT_WIDTH = 250;

	/** eLXg\ */
	public static final int TEXT_WIDTH1 = 120;

	/* Scroll CompositeTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 800 };

	private Text moniterText;

	/* Logging */
	private static Logger logger;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public EditorSSHNodeFileView() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		/* ͐ݒlm[hĎ擾 */
		EditorInputSSHNodeView nodeViewEditorInput = (EditorInputSSHNodeView) getEditorInput();

		File file = nodeViewEditorInput.getFile();
		/*
		 * ViewCAEg
		 */
		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, true);
		Composite composite0 = new Composite(scrollComposite, SWT.NONE);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL
				| GridData.VERTICAL_ALIGN_FILL));

		GridLayout gridLayout = new GridLayout(4, false);
		Composite composite1 = new Composite(composite0, SWT.NULL);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		GridLayout gridLayout2 = new GridLayout(1, true);
		Composite composite2 = new Composite(composite0, SWT.NONE);
		composite2.setLayoutData(new GridData(GridData.FILL_BOTH));

		composite2.setLayout(gridLayout2);

		moniterText = new Text(composite2, SWT.MULTI | SWT.BORDER
				| SWT.V_SCROLL | SWT.WRAP);
		moniterText.setText("");

		gridData = new GridData(GridData.FILL_BOTH);

		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;

		moniterText.setLayoutData(gridData);

		scrollComposite.setContent(composite0);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		try {
			parse(file.getPath());
		} catch (IOException e) {
			logger.warning("IOException " + e.getMessage() + " "
					+ file.getPath());
		}

	}

	public void parse(String file) throws IOException {

		BufferedReader buffReader = null;
		FileReader fi = null;
		try {
			fi = new FileReader(file);
			buffReader = new BufferedReader(fi);
		} catch (FileNotFoundException e1) {
			throw e1;
		}

		try {

			String message;

			while ((message = buffReader.readLine()) != null) {
				moniterText.append(message
						+ System.getProperty("line.separator"));
			}

		} catch (FileNotFoundException e1) {
			throw e1;
		} catch (IOException e) {
			throw e;
		} finally {
			if (buffReader != null) {
				try {
					buffReader.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}

			if (fi != null) {
				try {
					fi.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}
		}

	}

	/**
	 * Xe[^XC\Zbg܂B
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

}
