package netwatcher.ssh2.model;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.internal.ccvs.core.util.Util;


public class ResponsiveSocketFacory extends SimpleSocketFactory {

	private IProgressMonitor monitor;
	private static final int TIMEOUT = 10 * 1000;
	

	
	public void setMonitor(IProgressMonitor monitor) {
		this.monitor = monitor;
	}
		public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
			Socket socket = null;
			socket = Util.createSocket(host, port, monitor);
			// Null out the monitor so we don't hold onto anything
			// (i.e. the SSH2 session will keep a handle to the socket factory around
			monitor = new NullProgressMonitor();
			// Set the socket timeout
			socket.setSoTimeout(TIMEOUT);
			return socket;
		}

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ResponsiveSocketFacory getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final ResponsiveSocketFacory RESOURCE = new ResponsiveSocketFacory();
    }
}
