/*
 * Created on 2006/11/21
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.preference;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;

import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SSH2UserAuthManager {
	/** \[XXML l^O */
	public static final String XML_FILE_VALUE = "value";

	/** \[XXML root ^O */
	public static final String ROOT = "root";

	/** \[XXML target ^O */
	public static final String TARGET = "target";

	/** \[XXML password ^O */
	public static final String PASSWORD = "password";

	/** \[XXML passphrase ^O */
	public static final String PASSPHRASE = "passphrase";

	/* Logging */
	private static Logger logger = null;

	private String target;

	private String password;

	private String passphrase;

	public SSH2UserAuthManager() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public void getSystemResourceFileParse(String filePath) throws FileNotFoundException {

		Document doc = null;
		doc = getResourceFileDocumentPath(filePath);

		if (doc == null) {
			logger.severe("Resource File Doc null " + filePath);

			return;
		}

		try {

			// rootvfo
			Element root = doc.getRootElement();

			Element targetEl = root.getChild(TARGET);

			if (targetEl != null) {

				target = (root.getChild(TARGET))
						.getAttributeValue(XML_FILE_VALUE);
				password = (root.getChild(PASSWORD))
						.getAttributeValue(XML_FILE_VALUE);
				passphrase = (root.getChild(PASSPHRASE))
						.getAttributeValue(XML_FILE_VALUE);

			} else {
				logger.warning("target not found");
			}

		} catch (NullPointerException e) {
			e.printStackTrace();
		}
	}

	/**
	 * \[XBufferedWriterԂ܂B
	 * 
	 * @return bufferedWriter \[XBufferedWriter
	 */
	public BufferedWriter getResourceFileWriter(String filePath) {
		File f = new File(filePath);
		// logger.info("Path : " + f.getAbsolutePath());

		if (f == null) {
			return null;
		}

		BufferedWriter bufferedWriter = null;

		try {
			FileWriter fi = new FileWriter(filePath);
			bufferedWriter = new BufferedWriter(fi);
		} catch (IOException e1) {
			e1.printStackTrace();

			return null;
		}

		return bufferedWriter;
	}


	public Document getResourceFileDocumentPath(String file) throws FileNotFoundException {
		Document doc = null;

		File f = new File(file);
		// logger.info("Path : " + f.getAbsolutePath());

		if (f == null) {
			logger.warning("Abort create File : " + f.getAbsolutePath());

			return null;
		}

		BufferedReader d = null;

		try {
			FileReader fi = new FileReader(file);
			d = new BufferedReader(fi);
		} catch (FileNotFoundException e1) {
			logger.warning("FileNotFoundException : " + f.getPath() + " : "
					+ e1.getMessage());
			throw e1;
		}

		try {
			// FileInputStream stream = new FileInputStream(f);
			SAXBuilder builder = new SAXBuilder();
			doc = builder.build(d);
		} catch (JDOMException e) {
			logger.warning("JDOMException : " + e.getMessage());
			e.printStackTrace();
		} catch (NullPointerException e) {
			logger.warning("NullPointerException : " + e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			logger.warning("IOException : " + e.getMessage());
			e.printStackTrace();
		}

		return doc;
	}

	public Document updateDocument(String target, String password,
			String passphrase) {

		Element confElement = new Element(ROOT);
		Document doc = new Document(confElement);

		Element targetEl = new Element(TARGET);
		Element passwordEl = new Element(PASSWORD);
		Element passphraseEl = new Element(PASSPHRASE);

		confElement.addContent(targetEl);
		confElement.addContent(passwordEl);
		confElement.addContent(passphraseEl);

		targetEl.setAttribute(new Attribute(XML_FILE_VALUE, target));
		passwordEl.setAttribute(new Attribute(XML_FILE_VALUE, password));
		passphraseEl.setAttribute(new Attribute(XML_FILE_VALUE, passphrase));

		return doc;
	}

	public String getPassphrase() {
		return passphrase;
	}

	public String getPassword() {
		return password;
	}

	public String getTarget() {
		return target;
	}
}
