/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.actions;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.portscan.view.PortScanEditorView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * Port ScanɊւANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderPortScanOperationEditor extends Action {
	/*
	 * OIEditorParti[(ANVɈUClose邽)
	 */
	private static IEditorPart portScanEditor;

	/* MO */
	private static Logger logger;

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	/* Port Scan Editor\ANV */
	private IAction portScanEditorAction = new ActionPortScanEditor();

	public ActionBuilderPortScanOperationEditor() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public IAction getActionPortScanEditor() {
		return portScanEditorAction;
	}

	private abstract class AbstractPortScanAction extends Action {
		/**
		 * ANVs܂B
		 */
		public final void run() {
			doTask();
		}

		/**
		 * ANVs^XNłB
		 * 
		 */
		protected abstract void doTask();

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/file_obj.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "Port Scan";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "Port Scan";
		}
	}

	/**
	 * Port Scan Editor\ANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	public final class ActionPortScanEditor extends AbstractPortScanAction {
		/* m[hĎ */
		private NodeInformation nodeInfo;

		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			if (portScanEditor != null) {
				activePage.closeEditor(portScanEditor, false);
				portScanEditor = null;
			}

			try {
				portScanEditor = activePage.openEditor(new EditorInputNodeView(
						PortScanEditorView.TITLE_SUFFIX, nodeInfo, false),
						PortScanEditorView.class.getName());
			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}

		/**
		 * m[hĎZbg܂B
		 * 
		 * @param nodeInfo
		 *            m[hĎ
		 */
		public void setNodeInfo(NodeInformation nodeInfo) {
			this.nodeInfo = nodeInfo;
		}
	}

	public static void setPortScanEditor(IEditorPart portScanEditor) {
		ActionBuilderPortScanOperationEditor.portScanEditor = portScanEditor;
	}

	public static IEditorPart getPortScanEditor() {
		return portScanEditor;
	}

}
