/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.thread;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.portscan.thread.info.PortScanNode;
import netjfwatcher.portscan.thread.info.PortScanNodeList;
import netjfwatcher.portscan.thread.info.PortScanNodePort;

public class ThreadListReadQueuePushPortScan implements Runnable {
	/* Thread sleep */
	private static final int WAIT_SLEEP_TIME = 1000;

	/* MO */
	private static Logger logger = null;

	public ThreadListReadQueuePushPortScan() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public void run() {

		while (true) {

			Iterator it = null;
			Map baseList = PortScanBaseList.getInstance().getPortScanBaseList();
			for (it = baseList.keySet().iterator(); it.hasNext();) {
				String ipAddressKey = (String) it.next();
				PortScanNodeList portScanNodeList = (PortScanNodeList) baseList
						.get(ipAddressKey);

				if (portScanNodeList == null) {
					continue;
				}

				PortScanNode portScanNode = portScanNodeList
						.popPortScanNodeInfo(ipAddressKey);

				if (portScanNode == null) {
					continue;
				}

				Map nodePortList = portScanNode.getPortScanNodePortList();
				if (nodePortList == null) {
					continue;
				}
				Iterator it2 = null;
				for (it2 = nodePortList.keySet().iterator(); it2.hasNext();) {
					String portKey = (String) it2.next();
					PortScanNodePort portScanNodePort = (PortScanNodePort) nodePortList
							.get(portKey);

					if (portScanNodePort == null) {
						continue;
					}

					int count = portScanNodePort.getCountPeriod();
					/*
					 * System.out.println("count " + count);
					 * System.out.println("nodePortList.size() " +
					 * nodePortList.size());
					 * 
					 * System.out.println("portKey " + portKey);
					 * System.out.println("portScanNodePort.getPeriod() " +
					 * portScanNodePort.getPeriod());
					 * System.out.println("portScanNodePort.getCountPeriod() " +
					 * portScanNodePort.getCountPeriod());
					 */
					if (count != 0) {
						count--;
						portScanNodePort.setCountPeriod(count);

						if (count == 0) {

							PortScanQueue.getInstance().pushQue(
									portScanNodePort);
							portScanNodePort.setCountPeriod(portScanNodePort
									.getPeriod());
						}

					}
				}
			}

			try {
				Thread.sleep(WAIT_SLEEP_TIME);
			} catch (InterruptedException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}
	}
}
