/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.view;

import netjfwatcher.engine.calendar.CalendarView;
import netjfwatcher.engine.nodemaneger.list.NodeListTableView;
import netjfwatcher.engine.nodemaneger.list.NodeListTreeView;
import netjfwatcher.engine.nodemaneger.map.NodeMapView;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;



/**
 * Port Scan PerspectiveNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class PortScanManagerPerspective implements IPerspectiveFactory {
	public static final String ID = "netjfwatcher.portscan.view.PortScanManagerPerspective";
    private static final float NODE_TREE_RATIO = 0.20f;
    private static final float NODE_LIST_RATIO = 0.40f;

    /**
     * PerspectivȅCAEgs܂B
     *
     * @param layout IPageLayout
     */
    public void createInitialLayout(IPageLayout layout) {
        layout.setEditorAreaVisible(false);

        String editorArea = layout.getEditorArea();

        /* PerspectiveɃm[hTree */
        IFolderLayout left =
            layout.createFolder(
                "left", IPageLayout.LEFT, NODE_TREE_RATIO, editorArea);
        left.addView(PortScanNodeTreeView.class.getName());
        /* Perspective㑤Ƀm[hListƃm[hMap  */
        IFolderLayout top =
            layout.createFolder(
                "top", IPageLayout.TOP, NODE_LIST_RATIO, editorArea);
        top.addView(PortScanTableView.class.getName());
        top.addView(NodeListTableView.class.getName());
        top.addView(NodeMapView.class.getName());
    }
}
