/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.command;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import netwatcher.ssh2.command.CommandTaskScheduleInfo;
import netwatcher.ssh2.command.oneshotschedule.CommandTimerTask;
import netwatcher.ssh2.command.schedule.SchedulerCommandTask;

public final class CommandTaskScheduleControl {
    private static Logger logger = null;
    private Map taskScheduleList = Collections.synchronizedMap(new HashMap());

    private CommandTaskScheduleControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public synchronized void setTaskSchedule(String taskID, String target, String commandFileName, Date setStartDate) {
        String commandFilePath = "resources/ssh2/" + target + "/" + "command" + "/" + commandFileName;
        Timer taskTimer = new Timer();
        CommandTimerTask threadStartTask = new CommandTimerTask(target, commandFilePath);
        taskTimer.schedule((TimerTask)threadStartTask, setStartDate);
        CommandTaskScheduleInfo info = new CommandTaskScheduleInfo();
        info.setTaskStartDate(setStartDate);
        info.setTaskTimer(taskTimer);
        info.setTaskID(taskID);
        info.setTarget(target);
        info.setCommandFile(commandFileName);
        this.taskScheduleList.put(info.getTaskID(), info);
    }

    public synchronized void setTaskSchedule(String taskID, String target, String commandFileName, int dayOfMonth, int dayOfWeek, int hourOfDay, int minute) {
        String commandFilePath = "resources/ssh2/" + target + "/" + "command" + "/" + commandFileName;
        CommandTaskScheduleInfo info = new CommandTaskScheduleInfo();
        info.setTaskID(taskID);
        info.setTarget(target);
        info.setCommandFile(commandFilePath);
        if (dayOfMonth > 0) {
            info.setDayOfMonth(dayOfMonth);
            info.setDayOfMonthHour(hourOfDay);
            info.setDayOfMonthMinute(minute);
        }
        if (dayOfWeek > 0) {
            info.setDayOfWeek(dayOfWeek);
            info.setDayOfWeekHour(hourOfDay);
            info.setDayOfWeekMinute(minute);
        }
        SchedulerCommandTask commandTask = new SchedulerCommandTask(target, commandFilePath, dayOfMonth, dayOfWeek, hourOfDay, minute);
        commandTask.start();
        info.setCommandTask(commandTask);
        this.taskScheduleList.put(info.getTaskID(), info);
    }

    public synchronized void cancelTaskSchedule(CommandTaskScheduleInfo info) {
        logger.info("Cancel Task ID=" + info.getTaskID());
        if (info.getTaskTimer() != null) {
            info.getTaskTimer().cancel();
        } else if (info.getCommandTask() != null) {
            info.getCommandTask().stop();
        }
        this.taskScheduleList.remove(info.getTaskID());
    }

    public synchronized Map getTaskSchedule() {
        return this.taskScheduleList;
    }

    public static CommandTaskScheduleControl getInstance() {
        return SingletonResource.INSTANCE;
    }

    /* synthetic */ CommandTaskScheduleControl(CommandTaskScheduleControl commandTaskScheduleControl) {
        this();
    }

    private static class SingletonResource {
        static final CommandTaskScheduleControl INSTANCE = new CommandTaskScheduleControl(null);

        private SingletonResource() {
        }
    }
}

