/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.command.oneshotschedule;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netwatcher.ssh2.info.Credentials;
import netwatcher.ssh2.info.NetWatcherUserInfo;
import netwatcher.ssh2.info.SSHNodeInfo;
import netwatcher.ssh2.info.SSHNodeInfoControl;
import netwatcher.ssh2.info.SessionInfo;
import netwatcher.ssh2.model.SSHCommandThread;
import netwatcher.ssh2.preference.SSH2UserAuthManager;

public class OneshotCommandTask {
    private static Logger logger;
    private String target;
    private String commandFileName;

    public OneshotCommandTask(String target, String commandFileName) {
        logger = Logger.getLogger(this.getClass().getName());
        this.target = target;
        this.commandFileName = commandFileName;
    }

    public void executeCommand() {
        ArrayList commandList = null;
        SSH2UserAuthManager manager = new SSH2UserAuthManager();
        try {
            commandList = this.parseCommandFile(this.commandFileName);
            manager.getSystemResourceFileParse("resources/ssh2/" + this.target + "/" + "user_host_auth.xml");
        }
        catch (IOException iOException) {
            return;
        }
        String userHost = manager.getTarget();
        String user = "";
        String host = "";
        if (this.target.indexOf(64) > 0) {
            user = userHost.substring(0, userHost.indexOf(64));
            host = userHost.substring(userHost.indexOf(64) + 1);
        }
        this.setSSHInfo(user, host, manager.getPassword(), manager.getPassphrase());
        SSHCommandThread thread = new SSHCommandThread();
        thread.setUserHost(user, host);
        thread.setCommandList(commandList);
        thread.startSSHCommandThread();
    }

    /*
     * Exception decompiling
     */
    public ArrayList parseCommandFile(String commandFilePath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setSSHInfo(String userName, String host, String password, String passphrase) {
        Credentials cred = new Credentials();
        cred.setPassphrase(passphrase);
        File id_dsa_keyFile = new File("resources/ssh2/" + userName + "@" + host + "/" + "id_dsa");
        if (id_dsa_keyFile == null) {
            logger.warning("resources/id_dsa null");
        } else if (!id_dsa_keyFile.exists()) {
            logger.info("resources/id_dsa no exists");
        } else {
            cred.setIdDSAKeyFile(id_dsa_keyFile);
        }
        File id_rsa_keyFile = new File("resources/ssh2/" + userName + "@" + host + "/" + "id_rsa");
        ArrayList commandList = new ArrayList();
        if (id_rsa_keyFile == null) {
            logger.info("resources/id_rsa null");
        } else if (!id_rsa_keyFile.exists()) {
            logger.warning("resources/id_rsa no exists");
        } else {
            cred.setIdRSAKeyFile(id_rsa_keyFile);
        }
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setHost(host);
        sessionInfo.setPort(22);
        sessionInfo.setUserName(userName);
        NetWatcherUserInfo userInfo = new NetWatcherUserInfo(password, passphrase);
        SSHNodeInfo sshNodeInfo = new SSHNodeInfo();
        sshNodeInfo.setCredentials(cred);
        sshNodeInfo.setSshUserInfo(userInfo);
        sshNodeInfo.setSessionInfo(sessionInfo);
        sshNodeInfo.setCommandList(commandList);
        SSHNodeInfoControl.getInstance().setSSHInfo(String.valueOf(userName) + "@" + host, sshNodeInfo);
    }
}

