/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.command.schedule;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import netwatcher.ssh2.command.schedule.ScheduleIterator;

public class DailyIterator
implements ScheduleIterator {
    private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd (EEE) HH:mm:ss");
    private final int dayOfMonth;
    private final int dayOfWeek;
    private final int hourOfDay;
    private final int minute;
    private final int second;
    private final Calendar calendar = Calendar.getInstance();

    public DailyIterator(int dayOfMonth, int dayOfWeek, int hourOfDay, int minute) {
        this(dayOfMonth, dayOfWeek, hourOfDay, minute, new Date());
    }

    public DailyIterator(int dayOfMonth, int dayOfWeek, int hourOfDay, int minute, Date date) {
        this.dayOfMonth = dayOfMonth;
        this.dayOfWeek = dayOfWeek;
        this.hourOfDay = hourOfDay;
        this.minute = minute;
        this.second = 0;
        this.calendar.setTime(date);
        if (dayOfMonth > 0) {
            this.calendar.set(5, dayOfMonth);
        }
        if (dayOfWeek > 0) {
            this.calendar.set(7, dayOfWeek);
        }
        this.calendar.set(11, hourOfDay);
        this.calendar.set(12, minute);
        this.calendar.set(13, this.second);
        this.calendar.set(14, 0);
        if (!this.calendar.getTime().before(date)) {
            if (dayOfMonth > 0) {
                this.calendar.add(2, -1);
            } else if (dayOfWeek > 0) {
                this.calendar.add(5, -7);
            }
        }
    }

    public Date next() {
        if (this.dayOfMonth > 0) {
            this.calendar.add(2, 1);
        } else if (this.dayOfWeek > 0) {
            this.calendar.add(5, 7);
        }
        return this.calendar.getTime();
    }
}

