/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.command.schedule;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import netwatcher.ssh2.command.schedule.ScheduleIterator;
import netwatcher.ssh2.command.schedule.SchedulerTask;

public class Scheduler {
    private final Timer timer = new Timer();

    public void cancel() {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(SchedulerTask schedulerTask, ScheduleIterator iterator) {
        Date time = iterator.next();
        if (time == null) {
            schedulerTask.cancel();
        } else {
            Object object = schedulerTask.lock;
            synchronized (object) {
                if (schedulerTask.state != 0) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                schedulerTask.state = 1;
                schedulerTask.timerTask = new SchedulerTimerTask(schedulerTask, iterator);
                this.timer.schedule(schedulerTask.timerTask, time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reschedule(SchedulerTask schedulerTask, ScheduleIterator iterator) {
        Date time = iterator.next();
        if (time == null) {
            schedulerTask.cancel();
        } else {
            Object object = schedulerTask.lock;
            synchronized (object) {
                if (schedulerTask.state != 2) {
                    schedulerTask.timerTask = new SchedulerTimerTask(schedulerTask, iterator);
                    this.timer.schedule(schedulerTask.timerTask, time);
                }
            }
        }
    }

    class SchedulerTimerTask
    extends TimerTask {
        private SchedulerTask schedulerTask;
        private ScheduleIterator iterator;

        public SchedulerTimerTask(SchedulerTask schedulerTask, ScheduleIterator iterator) {
            this.schedulerTask = schedulerTask;
            this.iterator = iterator;
        }

        public void run() {
            this.schedulerTask.run();
            Scheduler.this.reschedule(this.schedulerTask, this.iterator);
        }
    }
}

