/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.command.schedule;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import netwatcher.ssh2.command.oneshotschedule.OneshotCommandTask;
import netwatcher.ssh2.command.schedule.DailyIterator;
import netwatcher.ssh2.command.schedule.Scheduler;
import netwatcher.ssh2.command.schedule.SchedulerTask;

public class SchedulerCommandTask {
    private String target;
    private String commandFileName;
    private final Scheduler scheduler = new Scheduler();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss.SSS");
    private final int dayOfMonth;
    private final int dayOfWeek;
    private final int hourOfDay;
    private final int minute;
    private static Logger logger;
    private SchedulerTask schedulerTask;

    public SchedulerCommandTask(String target, String commandFileName, int dayOfMonth, int dayOfWeek, int hourOfDay, int minute) {
        logger = Logger.getLogger(this.getClass().getName());
        this.target = target;
        this.commandFileName = commandFileName;
        this.dayOfMonth = dayOfMonth;
        this.dayOfWeek = dayOfWeek;
        this.hourOfDay = hourOfDay;
        this.minute = minute;
    }

    public void start() {
        this.schedulerTask = new SchedulerTask(){

            public void run() {
                logger.info("Wake up! It's " + SchedulerCommandTask.this.dateFormat.format(new Date()));
                OneshotCommandTask task = new OneshotCommandTask(SchedulerCommandTask.this.target, SchedulerCommandTask.this.commandFileName);
                task.executeCommand();
            }
        };
        this.scheduler.schedule(this.schedulerTask, new DailyIterator(this.dayOfMonth, this.dayOfWeek, this.hourOfDay, this.minute));
    }

    public void stop() {
        this.schedulerTask.cancel();
    }
}

