/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.gui.editor;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.common.view.CalendarComposite;
import netwatcher.ssh2.command.CommandTaskScheduleControl;
import netwatcher.ssh2.command.CommandTaskScheduleInfo;
import netwatcher.ssh2.gui.editor.AbstractEditorSSH;
import netwatcher.ssh2.gui.editor.EditorInputSSHNodeView;
import netwatcher.ssh2.gui.editor.EditorSSHCommandTimerProcessor;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditorSSHCommandScheduleView
extends AbstractEditorSSH {
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{800, 900};
    private static final int SCHEDULE_LIST_ITEM_HEIGHT = 12;
    private static final int COMMAND_LIST_ITEM_HEIGHT = 10;
    private static final int MONITOR_TEXT_WIDTH_HINT = 600;
    private static final int MONITOR_TEXT_HEIGHT_HINT = 400;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private static final int LIST_WIDTHHINT = 300;
    private static final int HORIZONTAL_SPAN3 = 3;
    private static final int HORIZONTAL_SPAN8 = 8;
    private static final String[] WEEK_STR_ARRY = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final int MONITOR_TIMER = 1000;
    private static Logger logger;
    private static List taskScheduleSortList;
    private SubStatusLineManager statusLineManager;
    private Button refreshButton;
    private Button sortButton;
    private Button cancelButton;
    private Button setButton;
    private org.eclipse.swt.widgets.List scheduleList;
    private org.eclipse.swt.widgets.List commandList;
    private Text assignmentYearText;
    private Text assignmentMonthText;
    private Text assignmentDateText;
    private Button assignmentDateButton;
    private Button dayCheckButton;
    private Button dayOfWeekCheckButton;
    private Combo assignmentDateHourCombo;
    private Combo assignmentDateMinuteCombo;
    private Combo dayOfMonthHourCombo;
    private Combo dayOfMonthMinuteCombo;
    private Combo dayOfWeekHourCombo;
    private Combo dayOfWeekMinuteCombo;
    private Combo dayOfMonthCombo;
    private Combo dayOfWeekCombo;
    private Button monitorResetButton;
    private Text moniterText;
    private Date setStartDate;
    private DateFormat dateformat;
    private boolean isSortDirection = true;
    public static final int DATE_TEXT_WIDTH = 250;
    public static final int TEXT_WIDTH1 = 120;
    private EditorSSHCommandTimerProcessor timerProcessor;
    private Display display;
    private String target;
    private String commandFileName;

    static {
        taskScheduleSortList = Collections.synchronizedList(new LinkedList());
    }

    public EditorSSHCommandScheduleView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        EditorInputSSHNodeView nodeViewEditorInput = (EditorInputSSHNodeView)this.getEditorInput();
        this.target = nodeViewEditorInput.getTarget();
        this.dateformat = new SimpleDateFormat("yyyy-MM-dd (EEE) HH:mm:ss");
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout0 = new GridLayout(2, true);
        Composite baseComposite = new Composite((Composite)scrollComposite, 0);
        baseComposite.setLayout((Layout)gridLayout0);
        baseComposite.setLayoutData((Object)new GridData());
        GridLayout gridLayoutListComp = new GridLayout(1, false);
        Composite compositeList = new Composite(baseComposite, 0);
        compositeList.setLayout((Layout)gridLayoutListComp);
        compositeList.setLayoutData((Object)new GridData(34));
        GridLayout gridLayoutOperation = new GridLayout(1, false);
        Composite compositeOperation = new Composite(baseComposite, 0);
        compositeOperation.setLayout((Layout)gridLayoutOperation);
        compositeOperation.setLayoutData((Object)new GridData(34));
        GridLayout gridLayoutButtonComp = new GridLayout(1, false);
        Composite compositeButton = new Composite(compositeOperation, 0);
        compositeButton.setLayout((Layout)gridLayoutButtonComp);
        compositeButton.setLayoutData((Object)new GridData());
        GridLayout gridLayoutDateTextComp = new GridLayout(8, false);
        Composite compositeDateText = new Composite(compositeOperation, 0);
        compositeDateText.setLayout((Layout)gridLayoutDateTextComp);
        compositeDateText.setLayoutData((Object)new GridData());
        GridLayout gridLayoutCalendar = new GridLayout(1, false);
        Composite compositeCalendar = new Composite(compositeOperation, 0);
        compositeCalendar.setLayoutData((Object)new GridData(256));
        compositeCalendar.setLayout((Layout)gridLayoutCalendar);
        GridLayout gridLayoutMonitor = new GridLayout(1, false);
        Composite compositeMonitor = new Composite(baseComposite, 0);
        compositeMonitor.setLayout((Layout)gridLayoutMonitor);
        GridData monitorGridData = new GridData();
        monitorGridData.horizontalSpan = 2;
        monitorGridData.verticalSpan = 1;
        compositeMonitor.setLayoutData((Object)monitorGridData);
        Label label = new Label(compositeList, 0);
        label.setText("Schedule List");
        GridData listGridData = new GridData();
        listGridData.horizontalSpan = 1;
        listGridData.verticalSpan = 1;
        label.setLayoutData((Object)listGridData);
        this.scheduleList = new org.eclipse.swt.widgets.List(compositeList, 2820);
        GridData data = new GridData(34);
        data.horizontalSpan = 1;
        data.verticalSpan = 10;
        data.widthHint = 300;
        data.heightHint = this.scheduleList.getItemHeight() * 12;
        this.scheduleList.setLayoutData((Object)data);
        label = new Label(compositeList, 0);
        label.setText("Command File List");
        listGridData = new GridData();
        listGridData.horizontalSpan = 1;
        listGridData.verticalSpan = 1;
        label.setLayoutData((Object)listGridData);
        this.commandList = new org.eclipse.swt.widgets.List(compositeList, 2820);
        data = new GridData(34);
        data.horizontalSpan = 1;
        data.verticalSpan = 10;
        data.widthHint = 300;
        data.heightHint = this.commandList.getItemHeight() * 10;
        this.commandList.setLayoutData((Object)data);
        this.monitorResetButton = new Button(compositeMonitor, 0);
        this.monitorResetButton.setText("Monitor reset");
        this.monitorResetButton.setLayoutData((Object)new GridData());
        this.moniterText = new Text(compositeMonitor, 2626);
        this.moniterText.setText("");
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 600;
        gridData.heightHint = 400;
        this.moniterText.setLayoutData((Object)gridData);
        this.refreshButton = new Button(compositeButton, 0);
        this.refreshButton.setText(" Refresh");
        this.refreshButton.setSize(150, 20);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.refreshButton.setLayoutData((Object)gridData);
        this.sortButton = new Button(compositeButton, 0);
        this.sortButton.setText(" Sort    ");
        this.sortButton.setSize(150, 20);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.sortButton.setLayoutData((Object)gridData);
        this.cancelButton = new Button(compositeButton, 0);
        this.cancelButton.setSize(150, 20);
        this.cancelButton.setText(" Cancel ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.cancelButton.setLayoutData((Object)gridData);
        this.setButton = new Button(compositeButton, 0);
        this.setButton.setSize(150, 20);
        this.setButton.setText(" Set     ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.setButton.setLayoutData((Object)gridData);
        this.assignmentDateButton = new Button(compositeDateText, 16);
        this.assignmentDateButton.setText("Assignment Date");
        this.assignmentDateButton.setSelection(true);
        this.assignmentDateButton.setLayoutData((Object)new GridData());
        this.assignmentYearText = new Text(compositeDateText, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 40;
        this.assignmentYearText.setLayoutData((Object)gridData);
        this.assignmentMonthText = new Text(compositeDateText, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.assignmentMonthText.setLayoutData((Object)gridData);
        label = new Label(compositeDateText, 0);
        label.setText("/");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.assignmentDateText = new Text(compositeDateText, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.assignmentDateText.setLayoutData((Object)gridData);
        this.assignmentDateHourCombo = new Combo(compositeDateText, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.assignmentDateHourCombo.setLayoutData((Object)gridData);
        this.setHourCombo(this.assignmentDateHourCombo);
        this.assignmentDateHourCombo.select(0);
        label = new Label(compositeDateText, 0);
        label.setText(":");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.assignmentDateMinuteCombo = new Combo(compositeDateText, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.assignmentDateMinuteCombo.setLayoutData((Object)gridData);
        this.setMinuteCombo(this.assignmentDateMinuteCombo);
        this.assignmentDateMinuteCombo.select(0);
        this.dayCheckButton = new Button(compositeDateText, 16);
        this.dayCheckButton.setText("Day of Month");
        this.dayOfMonthCombo = new Combo(compositeDateText, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.dayOfMonthCombo.setLayoutData((Object)gridData);
        this.setDayCombo(this.dayOfMonthCombo);
        this.dayOfMonthCombo.select(0);
        label = new Label(compositeDateText, 0);
        label.setText("");
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 3;
        gridData2.verticalSpan = 1;
        label.setLayoutData((Object)gridData2);
        this.dayOfMonthHourCombo = new Combo(compositeDateText, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.dayOfMonthHourCombo.setLayoutData((Object)gridData);
        this.setHourCombo(this.dayOfMonthHourCombo);
        this.dayOfMonthHourCombo.select(0);
        label = new Label(compositeDateText, 0);
        label.setText(":");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.dayOfMonthMinuteCombo = new Combo(compositeDateText, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.dayOfMonthMinuteCombo.setLayoutData((Object)gridData);
        this.setMinuteCombo(this.dayOfMonthMinuteCombo);
        this.dayOfMonthMinuteCombo.select(0);
        this.dayOfWeekCheckButton = new Button(compositeDateText, 16);
        this.dayOfWeekCheckButton.setText("Day of Week");
        this.dayOfWeekCombo = new Combo(compositeDateText, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.dayOfWeekCombo.setLayoutData((Object)gridData);
        this.setWeekCombo(this.dayOfWeekCombo);
        this.dayOfWeekCombo.select(0);
        label = new Label(compositeDateText, 0);
        label.setText("");
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 3;
        gridData3.verticalSpan = 1;
        label.setLayoutData((Object)gridData3);
        this.dayOfWeekHourCombo = new Combo(compositeDateText, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.dayOfWeekHourCombo.setLayoutData((Object)gridData);
        this.setHourCombo(this.dayOfWeekHourCombo);
        this.dayOfWeekHourCombo.select(0);
        label = new Label(compositeDateText, 0);
        label.setText(":");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.dayOfWeekMinuteCombo = new Combo(compositeDateText, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.dayOfWeekMinuteCombo.setLayoutData((Object)gridData);
        this.setMinuteCombo(this.dayOfWeekMinuteCombo);
        this.dayOfWeekMinuteCombo.select(0);
        CalendarComposite calendarComposite = new CalendarComposite();
        calendarComposite.setYearText(this.assignmentYearText);
        calendarComposite.setMonthText(this.assignmentMonthText);
        calendarComposite.setDateText(this.assignmentDateText);
        calendarComposite.setDayOfMonthCombo(this.dayOfMonthCombo);
        calendarComposite.setDayOfWeekCombo(this.dayOfWeekCombo);
        calendarComposite.createCalendarView(compositeCalendar);
        this.assignmentYearText.setText(calendarComposite.getCalendarTable().getTodaysYY());
        this.assignmentMonthText.setText(calendarComposite.getCalendarTable().getTodaysMM());
        this.assignmentDateText.setText(calendarComposite.getCalendarTable().getTodaysDD());
        scrollComposite.setContent((Control)baseComposite);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorSSHCommandScheduleView.logger = Logger.getLogger(this.getClass().getName());
                EditorSSHCommandScheduleView.this.refreshButton.setEnabled(false);
                EditorSSHCommandScheduleView.this.getTaskSchedule();
                EditorSSHCommandScheduleView.this.refreshButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.setButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorSSHCommandScheduleView.this.setButton.setEnabled(false);
                EditorSSHCommandScheduleView.this.getSelectDate();
                EditorSSHCommandScheduleView.this.setTaskSchedule();
                EditorSSHCommandScheduleView.this.getTaskSchedule();
                EditorSSHCommandScheduleView.this.setButton.setEnabled(true);
                EditorSSHCommandScheduleView.this.startTimer();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CommandTaskScheduleInfo taskInfo;
                EditorSSHCommandScheduleView.this.cancelButton.setEnabled(false);
                int selectListIndex = EditorSSHCommandScheduleView.this.scheduleList.getSelectionIndex();
                if (selectListIndex >= 0 && (taskInfo = (CommandTaskScheduleInfo)taskScheduleSortList.get(selectListIndex)) != null) {
                    EditorSSHCommandScheduleView.this.cancelTaskSchedule(taskInfo);
                    EditorSSHCommandScheduleView.this.getTaskSchedule();
                }
                EditorSSHCommandScheduleView.this.cancelButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.sortButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorSSHCommandScheduleView.this.sortButton.setEnabled(false);
                if (EditorSSHCommandScheduleView.this.isSortDirection) {
                    EditorSSHCommandScheduleView.this.isSortDirection = false;
                } else {
                    EditorSSHCommandScheduleView.this.isSortDirection = true;
                }
                EditorSSHCommandScheduleView.this.getTaskSchedule();
                EditorSSHCommandScheduleView.this.sortButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.commandList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = EditorSSHCommandScheduleView.this.commandList.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                System.out.println("Command " + EditorSSHCommandScheduleView.this.commandList.getItem(index));
                EditorSSHCommandScheduleView.this.commandFileName = EditorSSHCommandScheduleView.this.commandList.getItem(index);
            }
        });
        this.monitorResetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorSSHCommandScheduleView.this.moniterText.setText("");
            }
        });
        this.getTaskSchedule();
        this.setCommandList();
    }

    private void setCommandList() {
        File fleDir = new File("resources/ssh2/" + this.target + "/" + "command" + "/");
        File[] fileList = fleDir.listFiles();
        if (fileList != null) {
            int fileCount = 0;
            while (fileCount < fileList.length) {
                if (!fileList[fileCount].isDirectory()) {
                    this.commandList.add(fileList[fileCount].getName());
                }
                ++fileCount;
            }
        }
    }

    private void setHourCombo(Combo combo) {
        int i = 0;
        while (i < 24) {
            String work = Integer.toString(i);
            if (work.length() == 1) {
                work = "0" + work;
            }
            combo.add(work);
            ++i;
        }
    }

    private void setMinuteCombo(Combo combo) {
        int i = 0;
        while (i < 60) {
            String work = Integer.toString(i);
            if (work.length() == 1) {
                work = "0" + work;
            }
            combo.add(work);
            ++i;
        }
    }

    private void setDayCombo(Combo combo) {
        int i = 1;
        while (i <= 31) {
            String work = Integer.toString(i);
            if (work.length() == 1) {
                work = "0" + work;
            }
            combo.add(work);
            ++i;
        }
    }

    private void setWeekCombo(Combo combo) {
        int i = 0;
        while (i < WEEK_STR_ARRY.length) {
            combo.add(WEEK_STR_ARRY[i]);
            ++i;
        }
    }

    private void getTaskSchedule() {
        this.scheduleList.removeAll();
        taskScheduleSortList.clear();
        Map taskSchduleList = CommandTaskScheduleControl.getInstance().getTaskSchedule();
        int count = 0;
        for (String keyId : taskSchduleList.keySet()) {
            CommandTaskScheduleInfo info = (CommandTaskScheduleInfo)taskSchduleList.get(keyId);
            taskScheduleSortList.add(count, info);
            ++count;
        }
        Collections.sort(taskScheduleSortList, new Comparator(){

            public int compare(Object o1, Object o2) {
                String startData = ((CommandTaskScheduleInfo)o1).getTaskID();
                String startDate2 = ((CommandTaskScheduleInfo)o2).getTaskID();
                if (EditorSSHCommandScheduleView.this.isSortDirection) {
                    return startDate2.compareTo(startData);
                }
                return startData.compareTo(startDate2);
            }
        });
        int i = 0;
        while (i < taskScheduleSortList.size()) {
            CommandTaskScheduleInfo info = (CommandTaskScheduleInfo)taskScheduleSortList.get(i);
            String message = info.getTaskID();
            this.scheduleList.add(message);
            ++i;
        }
    }

    private String getDateStr(int dateData) {
        String work = Integer.toString(dateData);
        if (work.length() == 1) {
            work = "0" + work;
        }
        return work;
    }

    private void setTaskSchedule() {
        int selectDayOfWeekComboIndex;
        if (this.commandFileName == null || this.commandFileName.equals("")) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Please select command file ");
            return;
        }
        if (this.assignmentDateButton.getSelection()) {
            this.getSelectDate();
            Map taskSchduleList = CommandTaskScheduleControl.getInstance().getTaskSchedule();
            for (String keyId : taskSchduleList.keySet()) {
                CommandTaskScheduleInfo info = (CommandTaskScheduleInfo)taskSchduleList.get(keyId);
                if (info.getTaskStartDate() == null || !this.dateformat.format(this.setStartDate).equals(this.dateformat.format(info.getTaskStartDate()))) continue;
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("Already Start Date " + this.dateformat.format(this.setStartDate) + "  !"));
                return;
            }
            String message = String.valueOf(this.target) + " : " + this.dateformat.format(this.setStartDate) + " : " + this.commandFileName;
            CommandTaskScheduleControl.getInstance().setTaskSchedule(message, this.target, this.commandFileName, this.setStartDate);
        } else if (this.dayCheckButton.getSelection()) {
            int selectDayComboIndex = this.dayOfMonthCombo.getSelectionIndex();
            if (selectDayComboIndex >= 0) {
                int dayOfMonth = 0;
                int dayOfMonthHour = 0;
                int dayOfMonthMinute = 0;
                dayOfMonth = Integer.parseInt(this.dayOfMonthCombo.getText());
                dayOfMonthHour = Integer.parseInt(this.dayOfMonthHourCombo.getText());
                dayOfMonthMinute = Integer.parseInt(this.dayOfMonthMinuteCombo.getText());
                String message = String.valueOf(this.target) + " : Day Of Month " + dayOfMonth + " " + this.getDateStr(dayOfMonthHour) + ":" + this.getDateStr(dayOfMonthMinute) + " : " + this.commandFileName;
                CommandTaskScheduleControl.getInstance().setTaskSchedule(message, this.target, this.commandFileName, dayOfMonth, 0, dayOfMonthHour, dayOfMonthMinute);
            }
        } else if (this.dayOfWeekCheckButton.getSelection() && (selectDayOfWeekComboIndex = this.dayOfWeekCombo.getSelectionIndex()) >= 0) {
            int dayOfWeek = 0;
            int dayOfWeekHour = 0;
            int dayOfWeekMinute = 0;
            dayOfWeek = selectDayOfWeekComboIndex + 1;
            dayOfWeekHour = Integer.parseInt(this.dayOfWeekHourCombo.getText());
            dayOfWeekMinute = Integer.parseInt(this.dayOfWeekMinuteCombo.getText());
            String message = String.valueOf(this.target) + " : Day Of Week " + WEEK_STR_ARRY[dayOfWeek - 1] + "  " + this.getDateStr(dayOfWeekHour) + ":" + this.getDateStr(dayOfWeekMinute) + " : " + this.commandFileName;
            CommandTaskScheduleControl.getInstance().setTaskSchedule(message, this.target, this.commandFileName, 0, dayOfWeek, dayOfWeekHour, dayOfWeekMinute);
        }
    }

    private void getSelectDate() {
        int indexStartHH = this.assignmentDateHourCombo.getSelectionIndex();
        int indexStartMin = this.assignmentDateMinuteCombo.getSelectionIndex();
        int startYY = 0;
        try {
            startYY = Integer.parseInt(this.assignmentYearText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.assignmentYearText.setFocus();
            return;
        }
        int startMM = 0;
        try {
            startMM = Integer.parseInt(this.assignmentMonthText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.assignmentMonthText.setFocus();
            return;
        }
        int startDD = 0;
        try {
            startDD = Integer.parseInt(this.assignmentDateText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.assignmentDateText.setFocus();
            return;
        }
        int startHH = 0;
        try {
            startHH = Integer.parseInt(this.assignmentDateHourCombo.getItem(indexStartHH));
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.assignmentDateHourCombo.setFocus();
            return;
        }
        int startMIN = 0;
        try {
            startMIN = Integer.parseInt(this.assignmentDateMinuteCombo.getItem(indexStartMin));
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.assignmentDateMinuteCombo.setFocus();
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(startYY, startMM - 1, startDD, startHH, startMIN, 0);
        this.setStartDate = cal.getTime();
    }

    private void cancelTaskSchedule(CommandTaskScheduleInfo taskInfo) {
        if (taskInfo != null) {
            CommandTaskScheduleControl.getInstance().cancelTaskSchedule(taskInfo);
        }
    }

    private void startTimer() {
        EditorSSHCommandTimerProcessor.getInstance().setDisplay(this.display);
        EditorSSHCommandTimerProcessor.getInstance().setMonitorText(this.getEditorSite(), this.moniterText, null);
        this.timerProcessor = EditorSSHCommandTimerProcessor.getInstance();
        this.display.timerExec(1000, (Runnable)this.timerProcessor);
    }

    public void setFocus() {
    }

    protected void setStatusLine() {
    }
}

