/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.gui.editor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import netwatcher.ssh2.gui.editor.AbstractEditorSSH;
import netwatcher.ssh2.gui.editor.EditorInputSSHNodeView;
import netwatcher.ssh2.gui.editor.EditorSSHCommandTimerProcessor;
import netwatcher.ssh2.info.Credentials;
import netwatcher.ssh2.info.NetWatcherUserInfo;
import netwatcher.ssh2.info.SSHNodeInfo;
import netwatcher.ssh2.info.SSHNodeInfoControl;
import netwatcher.ssh2.info.SessionInfo;
import netwatcher.ssh2.model.SSHCommandThread;
import netwatcher.ssh2.preference.SSH2UserAuthManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditorSSHCommandView
extends AbstractEditorSSH {
    public static final String TITLE_SUFFIX = " Node View";
    public static final int DATE_TEXT_WIDTH = 250;
    public static final int TEXT_WIDTH1 = 120;
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{800, 800};
    private static final int HORIZONTAL_SPAN4 = 4;
    private static final int HORIZONTAL_SPAN6 = 6;
    private static final int MONITOR_TIMER = 1000;
    private EditorSSHCommandTimerProcessor timerProcessor;
    private Display display;
    private Button commandResetButton;
    private Button commandLoadButton;
    private Button commandSaveButton;
    private Text commandText;
    private Text moniterText;
    private Button commandButton;
    private Button monitorResetButton;
    private String target;
    private File commandFile;
    private String selectFileName;
    private static Logger logger;

    public EditorSSHCommandView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        EditorInputSSHNodeView nodeViewEditorInput = (EditorInputSSHNodeView)this.getEditorInput();
        this.commandFile = nodeViewEditorInput.getFile();
        this.target = nodeViewEditorInput.getTarget();
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite composite0 = new Composite((Composite)scrollComposite, 0);
        composite0.setLayout((Layout)gridLayout0);
        composite0.setLayoutData((Object)new GridData(272));
        GridLayout gridLayout = new GridLayout(1, false);
        Composite composite1 = new Composite(composite0, 0);
        composite1.setLayout((Layout)gridLayout);
        composite1.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        GridLayout gridLayout2 = new GridLayout(6, true);
        Composite composite2 = new Composite(composite0, 0);
        composite2.setLayoutData((Object)new GridData(1));
        composite2.setLayout((Layout)gridLayout2);
        this.commandResetButton = new Button(composite2, 0);
        this.commandResetButton.setText("Command reset");
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.commandResetButton.setLayoutData((Object)gd);
        this.commandLoadButton = new Button(composite2, 0);
        this.commandLoadButton.setText("Command load");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.commandLoadButton.setLayoutData((Object)gd);
        this.commandSaveButton = new Button(composite2, 0);
        this.commandSaveButton.setText("Command save");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.commandSaveButton.setLayoutData((Object)gd);
        Label label = new Label(composite2, 0);
        label.setText("");
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 3;
        gridData2.verticalSpan = 1;
        label.setLayoutData((Object)gridData2);
        this.commandText = new Text(composite2, 2626);
        this.commandText.setText("");
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.widthHint = 600;
        gridData.heightHint = 100;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.commandText.setLayoutData((Object)gridData);
        this.commandButton = new Button(composite2, 0);
        this.commandButton.setText("Command exec");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.commandButton.setLayoutData((Object)gd);
        this.monitorResetButton = new Button(composite2, 0);
        this.monitorResetButton.setText("Monitor reset");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.monitorResetButton.setLayoutData((Object)gd);
        label = new Label(composite2, 0);
        label.setText("");
        gridData2 = new GridData();
        gridData2.horizontalSpan = 4;
        gridData2.verticalSpan = 1;
        label.setLayoutData((Object)gridData2);
        this.moniterText = new Text(composite2, 2626);
        this.moniterText.setText("");
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.widthHint = 600;
        gridData.heightHint = 400;
        this.moniterText.setLayoutData((Object)gridData);
        scrollComposite.setContent((Control)composite0);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        if (this.commandFile != null) {
            try {
                this.parseCommandFile(this.commandFile.getPath());
            }
            catch (IOException e) {
                logger.warning("IOException : " + e.getMessage());
            }
        } else {
            this.commandLoadButton.setEnabled(false);
        }
        this.setSelectionListener();
    }

    private void setSelectionListener() {
        this.commandResetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorSSHCommandView.this.commandText.setText("");
            }
        });
        this.commandLoadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditorSSHCommandView.this.commandFile != null) {
                    EditorSSHCommandView.this.commandText.setText("");
                    try {
                        EditorSSHCommandView.this.parseCommandFile(EditorSSHCommandView.this.commandFile.getPath());
                    }
                    catch (IOException e2) {
                        MessageDialog.openError((Shell)EditorSSHCommandView.this.getSite().getShell(), (String)"Error", (String)("IOException " + e2.getMessage() + " " + EditorSSHCommandView.this.commandFile.getPath()));
                        return;
                    }
                }
            }
        });
        this.commandSaveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean ok;
                BufferedWriter bufferedWriter;
                OutputStreamWriter fileWriter;
                File selectCommandFile;
                block30: {
                    block31: {
                        String commandDirPath = "resources/ssh2/" + EditorSSHCommandView.this.target + "/" + "command";
                        File commandDir = new File(commandDirPath);
                        if (!commandDir.exists() && !commandDir.mkdirs()) {
                            MessageDialog.openError((Shell)EditorSSHCommandView.this.getEditorSite().getShell(), (String)"Error", (String)("Abrot mkdir." + System.getProperty("line.separator") + commandDir));
                            return;
                        }
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                FileDialog openDialog = new FileDialog(EditorSSHCommandView.this.getEditorSite().getShell(), 4096);
                                openDialog.setFilterPath("resources/ssh2/" + EditorSSHCommandView.this.target + "/" + "command" + "/");
                                EditorSSHCommandView.this.selectFileName = openDialog.open();
                            }
                        });
                        if (EditorSSHCommandView.this.selectFileName == null || EditorSSHCommandView.this.selectFileName.equals("")) {
                            return;
                        }
                        File selectCommandDir = new File("resources/ssh2/command/");
                        if (!selectCommandDir.exists()) {
                            if (!MessageDialog.openConfirm((Shell)EditorSSHCommandView.this.getEditorSite().getShell(), (String)"Confirmation", (String)(" does not exsit." + System.getProperty("line.separator") + "Are you sure you want to create it?"))) {
                                return;
                            }
                            if (!selectCommandDir.mkdirs()) {
                                MessageDialog.openError((Shell)EditorSSHCommandView.this.getEditorSite().getShell(), (String)"Error", (String)("Abrot mkdir." + System.getProperty("line.separator") + selectCommandDir));
                                return;
                            }
                        }
                        if ((selectCommandFile = new File(EditorSSHCommandView.this.selectFileName)).exists() && !MessageDialog.openConfirm((Shell)EditorSSHCommandView.this.getEditorSite().getShell(), (String)"Confirmation", (String)(selectCommandFile + " has already existed." + System.getProperty("line.separator") + "Are you sure you want to over write it?"))) {
                            return;
                        }
                        fileWriter = null;
                        bufferedWriter = null;
                        ok = true;
                        if (selectCommandFile != null) break block30;
                        if (bufferedWriter == null) break block31;
                        try {
                            bufferedWriter.close();
                        }
                        catch (Exception e1) {
                            logger.warning("Exception " + e1.getMessage());
                        }
                    }
                    if (fileWriter != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (Exception e2) {
                            logger.warning("Exception " + e2.getMessage());
                        }
                    }
                    return;
                }
                try {
                    try {
                        fileWriter = new FileWriter(selectCommandFile);
                        bufferedWriter = new BufferedWriter(fileWriter);
                        String commandString = EditorSSHCommandView.this.commandText.getText();
                        Pattern pattern = Pattern.compile(System.getProperty("line.separator"));
                        String[] commandStrArray = pattern.split(commandString);
                        if (commandStrArray != null) {
                            int i = 0;
                            while (i < commandStrArray.length) {
                                bufferedWriter.write(commandStrArray[i]);
                                ++i;
                            }
                        }
                    }
                    catch (Exception exception) {
                        ok = false;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (Exception e1) {
                            logger.warning("Exception " + e1.getMessage());
                        }
                    }
                    if (fileWriter != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (Exception e2) {
                            logger.warning("Exception " + e2.getMessage());
                        }
                    }
                }
                if (ok) {
                    MessageDialog.openInformation((Shell)EditorSSHCommandView.this.getEditorSite().getShell(), (String)"Information", (String)("Successfully saved." + System.getProperty("line.separator") + selectCommandFile));
                }
            }
        });
        this.monitorResetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorSSHCommandView.this.moniterText.setText("");
            }
        });
        this.commandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorSSHCommandView.this.commandButton.setEnabled(false);
                String commandString = EditorSSHCommandView.this.commandText.getText();
                Pattern pattern = Pattern.compile(System.getProperty("line.separator"));
                String[] commandStrArray = pattern.split(commandString);
                ArrayList<String> commandList = new ArrayList<String>();
                if (commandStrArray != null) {
                    int i = 0;
                    while (i < commandStrArray.length) {
                        System.out.println("command " + i + " : " + commandStrArray[i]);
                        commandList.add(commandStrArray[i]);
                        ++i;
                    }
                }
                System.out.println("target " + EditorSSHCommandView.this.target);
                SSH2UserAuthManager manager = new SSH2UserAuthManager();
                try {
                    manager.getSystemResourceFileParse("resources/ssh2/" + EditorSSHCommandView.this.target + "/" + "user_host_auth.xml");
                }
                catch (IOException e1) {
                    MessageDialog.openError((Shell)EditorSSHCommandView.this.getSite().getShell(), (String)"Error", (String)("IOException " + e1.getMessage() + " " + "resources/ssh2/" + EditorSSHCommandView.this.target + "/" + "user_host_auth.xml"));
                    EditorSSHCommandView.this.commandButton.setEnabled(true);
                    return;
                }
                String userHost = manager.getTarget();
                String user = "";
                String host = "";
                if (EditorSSHCommandView.this.target.indexOf(64) > 0) {
                    user = userHost.substring(0, userHost.indexOf(64));
                    host = userHost.substring(userHost.indexOf(64) + 1);
                }
                System.out.println("user " + user);
                System.out.println("host " + host);
                System.out.println("Password " + manager.getPassword());
                System.out.println("Passphrase " + manager.getPassphrase());
                EditorSSHCommandView.this.setSSHInfo(user, host, manager.getPassword(), manager.getPassphrase());
                SSHCommandThread thread = new SSHCommandThread();
                thread.setUserHost(user, host);
                thread.setCommandList(commandList);
                thread.startSSHCommandThread();
                EditorSSHCommandView.this.startTimer();
            }
        });
    }

    /*
     * Exception decompiling
     */
    public void parseCommandFile(String file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setSSHInfo(String userName, String host, String password, String passphrase) {
        Credentials cred = new Credentials();
        cred.setPassphrase(passphrase);
        File id_dsa_keyFile = new File("resources/ssh2/" + userName + "@" + host + "/" + "id_dsa");
        if (id_dsa_keyFile == null) {
            logger.warning("resources/id_dsa null");
        } else if (!id_dsa_keyFile.exists()) {
            logger.warning("resources/id_dsa no exists");
        } else {
            cred.setIdDSAKeyFile(id_dsa_keyFile);
        }
        File id_rsa_keyFile = new File("resources/ssh2/" + userName + "@" + host + "/" + "id_rsa");
        ArrayList commandList = new ArrayList();
        if (id_rsa_keyFile == null) {
            logger.warning("resources/id_rsa null");
        } else if (!id_rsa_keyFile.exists()) {
            logger.warning("resources/id_rsa no exists");
        } else {
            cred.setIdRSAKeyFile(id_rsa_keyFile);
        }
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setHost(host);
        sessionInfo.setPort(22);
        sessionInfo.setUserName(userName);
        NetWatcherUserInfo userInfo = new NetWatcherUserInfo(password, passphrase);
        SSHNodeInfo sshNodeInfo = new SSHNodeInfo();
        sshNodeInfo.setCredentials(cred);
        sshNodeInfo.setSshUserInfo(userInfo);
        sshNodeInfo.setSessionInfo(sessionInfo);
        sshNodeInfo.setCommandList(commandList);
        SSHNodeInfoControl.getInstance().setSSHInfo(String.valueOf(userName) + "@" + host, sshNodeInfo);
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    private void startTimer() {
        EditorSSHCommandTimerProcessor.getInstance().setDisplay(this.display);
        EditorSSHCommandTimerProcessor.getInstance().setMonitorText(this.getEditorSite(), this.moniterText, this.commandButton);
        this.timerProcessor = EditorSSHCommandTimerProcessor.getInstance();
        this.display.timerExec(1000, (Runnable)this.timerProcessor);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.display.timerExec(-1, (Runnable)this.timerProcessor);
    }
}

