/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.gui.treeview;

import java.util.logging.Logger;
import netwatcher.ssh2.gui.action.ActionBuilderNodeTree;
import netwatcher.ssh2.gui.treenode.ISSHUserHostTreeNode;
import netwatcher.ssh2.gui.treenode.SSHNodeTree;
import netwatcher.ssh2.gui.treenode.SSHNodeTreeGroup;
import netwatcher.ssh2.gui.treeview.AbstractSSHNodeTreeView;
import netwatcher.ssh2.gui.treeview.SSHNodeTreeListener;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;

public class SSHNodeTreeView
extends AbstractSSHNodeTreeView {
    private static Logger logger = null;

    public SSHNodeTreeView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    protected void initShow() {
        ((ActionBuilderNodeTree.ActionReloadNodeTree)this.actionNodeTree.actionReloadNodeTreeDatabase()).setNodeTree();
    }

    public void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SSHNodeTreeView.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.nodeTreeViewer.getControl());
        this.nodeTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.nodeTreeViewer);
    }

    protected void setToolBarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.getActionNodeTreeBuilder().actionReloadNodeTreeDatabase());
        toolBarManager.add(this.getActionNodeTreeBuilder().actionSortNodeTreeDatabase());
        toolBarManager.add(this.actionBuilderEditorPart.actionCloseAllEditors());
    }

    protected void fillContextMenu(IMenuManager manager) {
        TreeItem[] treeItem;
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.getActionNodeTreeBuilder().actionReloadNodeTreeDatabase());
        manager.add(this.getActionNodeTreeBuilder().actionSortNodeTreeDatabase());
        if (this.nodeTreeViewer.getTree().getSelection() != null && (treeItem = this.nodeTreeViewer.getTree().getSelection()) != null && treeItem.length > 0) {
            int nodeTreeSelectNo = 0;
            while (nodeTreeSelectNo < treeItem.length) {
                if (treeItem[nodeTreeSelectNo].getData() instanceof SSHNodeTreeGroup) {
                    if (!((SSHNodeTreeGroup)treeItem[nodeTreeSelectNo].getData()).getName().equals("command")) {
                        ((ActionBuilderNodeTree.ActionSSH2CommandView)this.actionNodeTree.actionOpenSSH2CommandView()).setSshNodeTree((ISSHUserHostTreeNode)treeItem[nodeTreeSelectNo].getData());
                        ((ActionBuilderNodeTree.ActionSSH2CommandSchedule)this.actionNodeTree.actionOpenSSH2CommandSchedule()).setSshNodeTree((ISSHUserHostTreeNode)treeItem[nodeTreeSelectNo].getData());
                        manager.add(this.actionNodeTree.actionOpenSSH2CommandView());
                        manager.add(this.actionNodeTree.actionOpenSSH2CommandSchedule());
                    } else {
                        this.nodeTreeViewer.getTree().deselectAll();
                    }
                } else if (!(treeItem[nodeTreeSelectNo].getData() instanceof SSHNodeTree)) {
                    this.nodeTreeViewer.getTree().deselectAll();
                }
                ++nodeTreeSelectNo;
            }
        }
    }

    protected void setupNodeTreeViewListener() {
        this.nodeTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new SSHNodeTreeListener());
    }
}

