/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.preference;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SSH2PasswordDialog
extends Dialog {
    protected Text passwordField;
    protected String password = null;
    protected String message = null;

    public SSH2PasswordDialog(Shell parentShell, String message) {
        super(parentShell);
        this.message = message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.message);
    }

    public void create() {
        super.create();
        this.passwordField.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        if (this.message != null) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setText(this.message);
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            messageLabel.setLayoutData((Object)data);
        }
        this.createPasswordFields(main);
        return main;
    }

    protected void createPasswordFields(Composite parent) {
        new Label(parent, 0).setText("Password:");
        this.passwordField = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.passwordField.setLayoutData((Object)data);
        this.passwordField.setEchoChar('*');
        new Label(parent, 0);
    }

    public String getPassword() {
        return this.password;
    }

    protected void okPressed() {
        String _password = this.passwordField.getText();
        if (_password == null || _password.length() == 0) {
            return;
        }
        this.password = _password;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.password = null;
        super.cancelPressed();
    }
}

